/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.opplugin.web.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsrbd.common.enums.LabelCategoryEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;

public class RepeatNameValidator
extends HRDataBaseValidator {
    private static final String TSC_TSRBS_FORMPLUGIN = "tsc-tsrbs-formplugin";
    private HRBaseServiceHelper ilServiceHelper = new HRBaseServiceHelper("tsrbd_individuallabel");
    private HRBaseServiceHelper plServiceHelper = new HRBaseServiceHelper("tsrbd_publiclabel");

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String category = dynamicObject.getString("labelcategory");
            if (HRStringUtils.equals((String)LabelCategoryEnum.IL.getCode(), (String)category)) {
                this.validateILLabel(dataEntity, dynamicObject);
            }
            if (!HRStringUtils.equals((String)LabelCategoryEnum.PL.getCode(), (String)category)) continue;
            this.validatePLLabel(dataEntity, dynamicObject);
        }
    }

    private void validatePLLabel(ExtendedDataEntity dataEntity, DynamicObject dynamicObject) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("labelcategory", "=", (Object)"B"));
        qFilters.add(new QFilter("name", "=", (Object)dynamicObject.getString("name")));
        String selectProperties = "id,number,createorg";
        DynamicObject[] dynamicObjects = this.plServiceHelper.query(selectProperties, qFilters.toArray(new QFilter[0]), "", 1);
        if (dynamicObjects.length > 0) {
            String msg;
            String dbId;
            String id = dynamicObject.getString("id");
            if (HRStringUtils.equals((String)id, (String)(dbId = dynamicObjects[0].getString("id")))) {
                return;
            }
            DynamicObject dbCreateOrg = dynamicObjects[0].getDynamicObject("createorg");
            String dbNumber = dynamicObjects[0].getString("number");
            IHRAppCache appCache = HRAppCache.get((String)"tsc");
            Set useOrgIds = (Set)appCache.get("app_key_tsc_tsrbd_public_label_use_orgs" + TSCRequestContext.getUserId(), Set.class);
            if (CollectionUtils.isEmpty((Collection)useOrgIds) || !useOrgIds.contains(dbCreateOrg.getString("id"))) {
                msg = String.format(ResManager.loadKDString((String)"\u4e0e%s\u516c\u5171\u6807\u7b7e\u91cd\u540d\uff0c\u8bf7\u8054\u7cfb%s\u7ba1\u7406\u5458\u53d8\u66f4", (String)"PublicLabelEdit_1", (String)TSC_TSRBS_FORMPLUGIN, (Object[])new Object[0]), dbNumber, dynamicObjects[0].getDynamicObject("createorg").getString("name"));
                this.addErrorMessage(dataEntity, msg);
            }
            if (CollectionUtils.isNotEmpty((Collection)useOrgIds) && useOrgIds.contains(dbCreateOrg.getString("id"))) {
                msg = String.format(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PublicLabelEdit_0", (String)TSC_TSRBS_FORMPLUGIN, (Object[])new Object[0]), new Object[0]);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private void validateILLabel(ExtendedDataEntity dataEntity, DynamicObject dynamicObject) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("labelcategory", "=", (Object)"A"));
        qFilters.add(new QFilter("creator", "=", (Object)TSCRequestContext.getUserId()));
        qFilters.add(new QFilter("name", "=", (Object)dynamicObject.getString("name")));
        String selectProperties = "id";
        DynamicObject[] dynamicObjects = this.ilServiceHelper.query(selectProperties, qFilters.toArray(new QFilter[0]), "", 1);
        if (dynamicObjects.length > 0) {
            String dbId;
            String id = dynamicObject.getString("id");
            if (HRStringUtils.equals((String)id, (String)(dbId = dynamicObjects[0].getString("id")))) {
                return;
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IndividualLabelEdit_0", (String)TSC_TSRBS_FORMPLUGIN, (Object[])new Object[0]));
        }
    }
}

