/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.opplugin.web.op.process;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessServiceHelper;
import kd.tsc.tsrbd.opplugin.web.validator.process.RecruitmentStagValidator;

public class RecruitmentStageOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        super.onAddValidators(eventArgs);
        eventArgs.addValidator((AbstractValidator)new RecruitmentStagValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject dataEntity = args.getDataEntities()[0];
        long id = dataEntity.getLong("id");
        DynamicObject[] stages = ProcessServiceHelper.getProcessByStageId((Long)id);
        List oldStatColl = Arrays.stream(stages).map(stage -> stage.getLong("stat.id")).collect(Collectors.toList());
        DynamicObjectCollection statselnewentry = dataEntity.getDynamicObjectCollection("statselnewentry");
        List newStatColl = statselnewentry.stream().map(stat -> stat.getLong("stat.id")).collect(Collectors.toList());
        ArrayList needDeleteList = Lists.newArrayListWithCapacity((int)10);
        Arrays.stream(stages).forEach(oldStat -> {
            long statId = oldStat.getLong("stat.id");
            if (!newStatColl.contains(statId)) {
                needDeleteList.add(oldStat.getLong("id"));
            }
        });
        List needAddStatList = newStatColl.stream().filter(newStat -> !oldStatColl.contains(newStat)).collect(Collectors.toList());
        if (!needAddStatList.isEmpty()) {
            ProcessServiceHelper.updateProcessStageStatus((Long)id, needAddStatList);
        }
        if (!needDeleteList.isEmpty()) {
            ProcessServiceHelper.delStat((List)needDeleteList);
        }
    }
}

