/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.opplugin.web.position.process;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessConfigModalHelper;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessServiceHelper;

public class ProcessSaveOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] entities;
                for (ExtendedDataEntity entity : entities = this.dataEntities) {
                    DynamicObject process = entity.getDataEntity();
                    String message = ProcessServiceHelper.judgeProcessIsDefault((DynamicObject)process);
                    if (!HRStringUtils.isNotEmpty((String)message)) continue;
                    this.addErrorMessage(entity, message);
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] entities;
        for (DynamicObject dynamicObject : entities = args.getDataEntities()) {
            ProcessServiceHelper.saveProcess((DynamicObject)dynamicObject);
            long processId = dynamicObject.getLong("id");
            String processOperate = this.getOption().getVariableValue("result_process_operate");
            Optional.ofNullable(processOperate).ifPresent(operateOption -> {
                List list = (List)SerializationUtils.fromJsonString((String)operateOption, List.class);
                ProcessConfigModalHelper.saveOperateConfig((List)list, (Long)processId);
            });
            String processField = this.getOption().getVariableValue("result_process_field");
            Optional.ofNullable(processField).ifPresent(fieldOption -> {
                List list = (List)SerializationUtils.fromJsonString((String)fieldOption, List.class);
                ProcessConfigModalHelper.saveFieldConfig((List)list, (Long)processId);
            });
        }
    }
}

