/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.opplugin.web.recyleresume;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.EmailConfigService;
import kd.tsc.tsrbd.opplugin.web.validator.recyleresume.EmailInfoSaveValidator;

public class EmailInfoSaveOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EmailInfoSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dys;
        for (DynamicObject dyn : dys = e.getDataEntities()) {
            dyn.set("mailstatus", (Object)"1");
            dyn.set("status", (Object)"C");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dys = e.getDataEntities();
        Arrays.stream(dys).forEach(dyn -> {
            String emailAddress = dyn.getString("emailaddr");
            String protocolType = dyn.getString("protocoltype");
            String suffix = "@" + emailAddress.split("@")[1];
            DynamicObject emailConfig = EmailConfigService.getInstance().getMailConfigBySuffixAndProtocoltype(suffix, protocolType);
            if (emailConfig == null) {
                EmailConfigService.getInstance().saveEmailConfig(dyn);
            }
        });
    }
}

