/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.opplugin.web.rewardrule.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsrbd.business.domain.rewardrule.RewardRuleDataHelper;
import kd.tsc.tsrbd.business.domain.rewardrule.RewardRuleQFilterHelper;

public class RewardRuleSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        this.currencyValidate();
    }

    private void currencyValidate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject rewardRule = dataEntity.getDataEntity();
            if (this.nameUniqueValidate(rewardRule)) {
                return;
            }
            DynamicObjectCollection processCollection = rewardRule.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection onboardCollection = rewardRule.getDynamicObjectCollection("entryentity1");
            HashSet<Long> currencySet = new HashSet<Long>(processCollection.size() + onboardCollection.size());
            ArrayList<Set<Integer>> theSameSetList = new ArrayList<Set<Integer>>(onboardCollection.size() * 2);
            if (this.processSaveValidate(processCollection, currencySet)) {
                return;
            }
            if (this.onboardSaveValidate(onboardCollection, currencySet, theSameSetList)) {
                return;
            }
            if (currencySet.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u4fdd\u6301\u5956\u52b1\u5e01\u79cd\u4e00\u81f4\u3002", (String)"RewardRuleSaveValidator_1", (String)"tsc-tsrbd-opplugin", (Object[])new Object[0]));
                return;
            }
            if (theSameSetList.size() <= 0) continue;
            boolean[] repeat = new boolean[]{false};
            this.jobScmIntersectionValidator(onboardCollection, theSameSetList, repeat);
            if (!repeat[0]) continue;
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u76f8\u540c\u62db\u8058\u73af\u8282\u3001\u72b6\u6001\u3001\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u548c\u804c\u4f4d\u65cf\u7684\u804c\u7ea7\u3001\u804c\u7b49\u4e0d\u80fd\u6709\u4ea4\u96c6\u3002", (String)"RewardRuleSaveValidator_5", (String)"tsc-tsrbd-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void jobScmIntersectionValidator(DynamicObjectCollection onboardCollection, List<Set<Integer>> theSameSetList, boolean[] repeat) {
        theSameSetList.stream().forEach(set -> {
            DynamicObject jobFamilyScm = null;
            DynamicObject[] jobGradeArray = null;
            DynamicObject[] jobLevelArray = null;
            String[] length = new String[]{};
            HashSet<String> repeatSet = new HashSet<String>(onboardCollection.size() * 3);
            for (Integer index : set) {
                if (repeat[0]) {
                    return;
                }
                DynamicObject onboard = (DynamicObject)onboardCollection.get(index.intValue());
                if (jobFamilyScm == null) {
                    long jobScm = onboard.getDynamicObject("jobscmhr1").getLong("id");
                    long jobFamily = onboard.getDynamicObject("jobfamilyhr1").getLong("id");
                    jobFamilyScm = RewardRuleDataHelper.getInstance().queryJobFamilyScm(jobScm, jobFamily);
                    long jobGrade = jobFamilyScm.getDynamicObject("jobgradescm").getLong("id");
                    long jobLevel = jobFamilyScm.getDynamicObject("joblevelscm").getLong("id");
                    jobGradeArray = RewardRuleDataHelper.getInstance().queryJobGrade(jobGrade);
                    jobLevelArray = RewardRuleDataHelper.getInstance().queryJobLevel(jobLevel);
                    length = new String[jobLevelArray.length * jobGradeArray.length];
                    int seq = 0;
                    this.fillValidData(jobGradeArray, jobLevelArray, length, seq);
                }
                this.validSameJobData(repeat, length, repeatSet, onboard);
            }
        });
    }

    private void validSameJobData(boolean[] repeat, String[] length, Set<String> repeatSet, DynamicObject onboard) {
        long lowLevel = onboard.getDynamicObject("classlevellow1").getLong("id");
        long highLevel = onboard.getDynamicObject("classlevelhigh1").getLong("id");
        long lowGrade = onboard.getDynamicObject("lowjobgrade1").getLong("id");
        long highGrade = onboard.getDynamicObject("highjobgrade1").getLong("id");
        boolean start = false;
        boolean end = false;
        for (int i = 0; i < length.length; ++i) {
            if (HRStringUtils.equals((String)("" + lowLevel + lowGrade), (String)("" + highLevel + highGrade))) {
                if (repeatSet.contains("" + lowLevel + lowGrade)) {
                    repeat[0] = true;
                    break;
                }
                repeatSet.add("" + lowLevel + lowGrade);
                break;
            }
            if (start && end) break;
            if (HRStringUtils.equals((String)length[i], (String)("" + highLevel + highGrade))) {
                if (repeatSet.contains(length[i])) {
                    repeat[0] = true;
                    break;
                }
                repeatSet.add(length[i]);
                end = true;
                continue;
            }
            if (start) {
                if (repeatSet.contains(length[i])) {
                    repeat[0] = true;
                    break;
                }
                repeatSet.add(length[i]);
                continue;
            }
            if (!HRStringUtils.equals((String)length[i], (String)("" + lowLevel + lowGrade))) continue;
            if (repeatSet.contains(length[i])) {
                repeat[0] = true;
                break;
            }
            repeatSet.add(length[i]);
            start = true;
        }
    }

    private void fillValidData(DynamicObject[] jobGradeArray, DynamicObject[] jobLevelArray, String[] length, int seq) {
        for (int i = 0; i < jobLevelArray.length; ++i) {
            for (int j = 0; j < jobGradeArray.length; ++j) {
                length[seq] = "" + jobLevelArray[i].getLong("id") + jobGradeArray[j].getLong("id");
                ++seq;
            }
        }
    }

    private boolean nameUniqueValidate(DynamicObject rewardRule) {
        String name = rewardRule.getString("name").trim();
        QFilter qFilter = RewardRuleQFilterHelper.queryByEquals((String)"name", (Object)name);
        DynamicObject[] query = RewardRuleDataHelper.getInstance().query(qFilter.toArray());
        if (query.length != 0 && query[0].getLong("id") != rewardRule.getLong("id")) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u540d\u79f0\u3002", (String)"RewardRuleSaveValidator_0", (String)"tsc-tsrbd-opplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean onboardSaveValidate(DynamicObjectCollection onboardCollection, Set<Long> currencySet, List<Set<Integer>> theSame) {
        AtomicBoolean error = new AtomicBoolean(false);
        AtomicInteger seq = new AtomicInteger(0);
        HashMap map = new HashMap(onboardCollection.size() * 2);
        if (!onboardCollection.isEmpty()) {
            onboardCollection.stream().forEach(dy -> {
                if (error.get()) {
                    return;
                }
                if (this.currencyValidate(currencySet, (DynamicObject)dy, "rewarditem1", "currency1")) {
                    error.set(true);
                    return;
                }
                boolean jobScmSwitch = dy.getBoolean("jobscmhrswitch1");
                if (jobScmSwitch) {
                    if (this.jobScmMustInputValidate((DynamicObject)dy)) {
                        error.set(true);
                        return;
                    }
                    long recrustat = dy.getDynamicObject("recrustatnew1").getLong("id");
                    long jobScm = dy.getDynamicObject("jobscmhr1").getLong("id");
                    long jobFamily = dy.getDynamicObject("jobfamilyhr1").getLong("id");
                    String same = "" + recrustat + jobScm + jobFamily;
                    if (map.containsKey(same)) {
                        ((Set)map.get(same)).add(seq.get());
                    }
                    if (map.get(same) == null) {
                        HashSet<Integer> set = new HashSet<Integer>();
                        set.add(seq.get());
                        map.put(same, set);
                    }
                }
                seq.getAndIncrement();
            });
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            theSame.add((Set<Integer>)entry.getValue());
        }
        return error.get();
    }

    private boolean jobScmMustInputValidate(DynamicObject dy) {
        if (dy.getDynamicObject("jobscmhr1") == null || dy.getDynamicObject("jobfamilyhr1") == null || HRStringUtils.isEmpty((String)dy.getString("classgraderange1")) || HRStringUtils.isEmpty((String)dy.getString("classlevelrange1"))) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u5173\u8054\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u6253\u5f00\u540e\uff0c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u3001\u804c\u4f4d\u65cf\u3001\u5173\u8054\u804c\u7ea7\u8303\u56f4\u3001\u5173\u8054\u804c\u7b49\u8303\u56f4\u4e3a\u5fc5\u586b\u3002", (String)"RewardRuleSaveValidator_3", (String)"tsc-tsrbd-opplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean processSaveValidate(DynamicObjectCollection processCollection, Set<Long> currencySet) {
        AtomicBoolean error = new AtomicBoolean(false);
        if (!processCollection.isEmpty()) {
            processCollection.stream().forEach(dy -> {
                if (this.currencyValidate(currencySet, (DynamicObject)dy, "rewarditem", "currency")) {
                    error.set(true);
                    return;
                }
            });
        }
        return error.get();
    }

    private boolean currencyValidate(Set<Long> currencySet, DynamicObject dy, String rewardItem, String currency) {
        if (HRStringUtils.equals((String)dy.getString(rewardItem), (String)"A")) {
            DynamicObject curr = dy.getDynamicObject(currency);
            if (curr == null) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u5956\u91d1\u9879\u76ee\u4e3a\u5956\u91d1\u65f6\uff0c\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RewardRuleSaveValidator_4", (String)"tsc-tsrbd-opplugin", (Object[])new Object[0]));
                return true;
            }
            currencySet.add(curr.getLong("id"));
        }
        return false;
    }
}

