/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.constants.deserializer;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.constants.deserializer.impl.BaseDeserializer;
import kd.tsc.tsrbd.common.constants.deserializer.impl.DateDeserializer;
import kd.tsc.tsrbd.common.constants.deserializer.impl.StringDeserializer;

public final class DefaultDeserializer
extends BaseDeserializer {
    private static final Map<String, BaseDeserializer> DESERIALZIERMAP = Maps.newConcurrentMap();

    public static BaseDeserializer getDeserializer(String classType) {
        BaseDeserializer baseDeserializer = DESERIALZIERMAP.get(classType);
        return baseDeserializer == null ? new DefaultDeserializer() : baseDeserializer;
    }

    public static void addDeserializer(String classType, BaseDeserializer deserializer) {
        if (HRStringUtils.isEmpty((String)classType)) {
            return;
        }
        if (deserializer == null) {
            return;
        }
        if (DESERIALZIERMAP.containsKey(classType)) {
            DESERIALZIERMAP.replace(classType, deserializer);
        } else {
            DESERIALZIERMAP.put(classType, deserializer);
        }
    }

    @Override
    public void parserValue(DynamicObject dynObj, String key, Object value, String ... strs) {
        dynObj.set(key, value);
    }

    static {
        DESERIALZIERMAP.put("Date", new DateDeserializer());
        DESERIALZIERMAP.put("String", new StringDeserializer());
    }
}

