/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.constants.deserializer.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbd.common.constants.deserializer.impl.BaseDeserializer;

public class DateDeserializer
extends BaseDeserializer {
    private static final Log LOG = LogFactory.getLog(DateDeserializer.class);
    private static final String FORMAT_SHORT = "yyyy-MM-dd";

    @Override
    public void parserValue(DynamicObject dynObj, String key, Object value, String ... strs) {
        if (value == null) {
            return;
        }
        LOG.info("Date parser begin\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)value.toString());
        try {
            if (value.toString().length() > 10) {
                value = value.toString().substring(0, 10);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_SHORT);
            Date parseDate = simpleDateFormat.parse(value.toString());
            dynObj.set(key, (Object)parseDate);
        }
        catch (Exception e) {
            LOG.error("Date parser error\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", new Object[]{key, value.toString(), e});
        }
    }
}

