/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.constants.intv.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.tsc.tsrbd.common.constants.intv.model.IQuestionnaireCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.OptionCacheModel;

public class QuestionCacheModel
implements IQuestionnaireCacheModel,
Comparable<QuestionCacheModel> {
    private Long id;
    private Object questionContent;
    private Object questionDesc;
    private String questionType;
    private Integer index;
    private Boolean required;
    private Boolean enableComment;
    private Boolean requiredComment;
    private List<OptionCacheModel> options;

    public void removeOptionLastElement() {
        List<OptionCacheModel> options = this.getOptions();
        if (options == null || options.isEmpty() || options.size() == 1) {
            return;
        }
        options.remove(options.size() - 1);
    }

    public void addOptions(OptionCacheModel option) {
        if (this.options == null) {
            this.options = new ArrayList<OptionCacheModel>(10);
        }
        this.options.add(option);
    }

    public void addEmptyOptions(int num) {
        for (int i = 0; i < num; ++i) {
            this.addOptions(new OptionCacheModel());
        }
    }

    public void modifyOptionName(Integer index, Object name) {
        if (this.options == null) {
            return;
        }
        OptionCacheModel optionCacheModel = this.options.get(index);
        optionCacheModel.setName(name);
    }

    public void setQuestionType(String questionType) {
        this.questionType = questionType;
    }

    public QuestionCacheModel() {
    }

    public QuestionCacheModel(String questionType) {
        this.questionType = questionType;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Object getName() {
        return this.questionContent;
    }

    @Override
    public void setName(Object name) {
    }

    public Object getQuestionContent() {
        return this.questionContent;
    }

    public void setQuestionContent(Object questionContent) {
        this.questionContent = questionContent;
    }

    public Object getQuestionDesc() {
        return this.questionDesc;
    }

    public void setQuestionDesc(Object questionDesc) {
        this.questionDesc = questionDesc;
    }

    public String getQuestionType() {
        return this.questionType;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Boolean getRequired() {
        return this.required == null ? Boolean.TRUE : this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getEnableComment() {
        return this.enableComment == null ? Boolean.FALSE : this.enableComment;
    }

    public void setEnableComment(Boolean enableComment) {
        this.enableComment = enableComment;
    }

    public Boolean getRequiredComment() {
        return this.requiredComment == null ? Boolean.FALSE : this.requiredComment;
    }

    public void setRequiredComment(Boolean requiredComment) {
        this.requiredComment = requiredComment;
    }

    public List<OptionCacheModel> getOptions() {
        return this.options;
    }

    public void setOptions(List<OptionCacheModel> options) {
        this.options = options;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuestionCacheModel model = (QuestionCacheModel)obj;
        return Objects.equals(this.id, model.id) && Objects.equals(this.questionContent, model.questionContent) && Objects.equals(this.questionDesc, model.questionDesc) && Objects.equals(this.questionType, model.questionType) && Objects.equals(this.index, model.index) && Objects.equals(this.required, model.required) && Objects.equals(this.enableComment, model.enableComment) && Objects.equals(this.requiredComment, model.requiredComment) && Objects.equals(this.options, model.options);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.questionContent, this.questionDesc, this.questionType, this.index, this.required, this.enableComment, this.requiredComment, this.options);
    }

    @Override
    public int compareTo(QuestionCacheModel model) {
        int compare = this.getIndex() == null || model.getIndex() == null ? 1 : Integer.compare(this.getIndex(), model.getIndex());
        int val = this.getId() == null || model.getId() == null ? 1 : Long.compare(this.getId(), model.getId());
        return compare != 0 ? compare : val;
    }
}

