/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.dto;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.tsc.tsrbd.common.enums.TSCErrorCodeEnum;

public class TSCBaseResponseDTO {
    private TSCErrorCodeEnum errorCode;
    private String customLangMessage;
    private Object data;

    public static TSCBaseResponseDTO fail(TSCErrorCodeEnum code) {
        if (code == TSCErrorCodeEnum.SUCCESS) {
            throw new IllegalArgumentException("TSCErrorCodeEnum must not been success");
        }
        TSCBaseResponseDTO dto = new TSCBaseResponseDTO();
        dto.errorCode = code;
        return dto;
    }

    public static TSCBaseResponseDTO fail(TSCErrorCodeEnum code, String customLangMessage) {
        if (code == TSCErrorCodeEnum.SUCCESS) {
            throw new IllegalArgumentException("TSCErrorCodeEnum must not been success");
        }
        TSCBaseResponseDTO dto = new TSCBaseResponseDTO();
        dto.customLangMessage = customLangMessage;
        dto.errorCode = code;
        return dto;
    }

    public static TSCBaseResponseDTO success() {
        TSCBaseResponseDTO dto = new TSCBaseResponseDTO();
        dto.errorCode = TSCErrorCodeEnum.SUCCESS;
        return dto;
    }

    public static TSCBaseResponseDTO success(Object data) {
        TSCBaseResponseDTO dto = new TSCBaseResponseDTO();
        dto.errorCode = TSCErrorCodeEnum.SUCCESS;
        dto.data = data;
        return dto;
    }

    public TSCErrorCodeEnum getErrorCode() {
        return this.errorCode;
    }

    public Object getData() {
        return this.data;
    }

    public String getCustomLangMessage() {
        return this.customLangMessage;
    }

    public boolean isSuccess() {
        return this.errorCode == TSCErrorCodeEnum.SUCCESS;
    }

    public ApiResult convertApiResult() {
        ApiResult apiResult = new ApiResult();
        apiResult.setSuccess(this.isSuccess());
        apiResult.setHttpStatus(Integer.valueOf(200));
        apiResult.setErrorCode(this.getErrorCode().getCode());
        if (StringUtils.isNotBlank((CharSequence)this.getCustomLangMessage())) {
            apiResult.setMessage(String.join((CharSequence)",", this.getErrorCode().getLangMessage(), this.getCustomLangMessage()));
        } else {
            apiResult.setMessage(this.getErrorCode().getLangMessage());
        }
        if (this.getData() != null) {
            apiResult.setData(this.getData());
        }
        return apiResult;
    }
}

