/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.enums;

import com.google.common.collect.Maps;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.function.UnaryOperator;

public enum DatePeriodEnum {
    PAST_ONE_YEAR("past_one_year", date -> date.minusYears(1L)),
    PAST_HALF_YEAR("past_half_year", date -> date.minusMonths(6L)),
    PAST_THREE_MONTH("past_three_month", date -> date.minusMonths(3L)),
    PAST_ONE_MONTH("past_one_month", date -> date.minusMonths(1L)),
    PAST_HALF_MONTH("past_half_month", date -> date.minusDays(15L)),
    PAST_SEVEN_DAYS("past_seven_days", date -> date.minusDays(6L)),
    PAST_THREE_DAYS("past_three_days", date -> date.minusDays(2L)),
    TODAY("today", date -> date),
    NEST_ONE_YEAR("nest_one_year", date -> date.plusYears(1L)),
    NEST_HALF_YEAR("nest_half_year", date -> date.plusMonths(6L)),
    NEST_THREE_MONTH("nest_three_month", date -> date.plusMonths(3L)),
    NEST_ONE_MONTH("nest_one_month", date -> date.plusMonths(1L)),
    NEST_HALF_MONTH("nest_half_month", date -> date.plusDays(15L)),
    NEST_SEVEN_DAYS("nest_seven_days", date -> date.plusDays(6L)),
    NEST_THREE_DAYS("nest_three_days", date -> date.plusDays(2L)),
    THIS_WEEK("this_week", date -> date.with(DayOfWeek.MONDAY)),
    THIS_MONTH("this_month", date -> date.with(TemporalAdjusters.firstDayOfMonth()));

    private static HashMap<String, DatePeriodEnum> initHashMap;
    private String code;
    private UnaryOperator<LocalDate> function;

    private DatePeriodEnum(String code, UnaryOperator<LocalDate> function) {
        this.code = code;
        this.function = function;
    }

    public String getCode() {
        return this.code;
    }

    public UnaryOperator<LocalDate> getFunction() {
        return this.function;
    }

    public static DatePeriodEnum getByCode(String code) {
        return initHashMap.get(code);
    }

    static {
        initHashMap = Maps.newHashMapWithExpectedSize((int)15);
        for (DatePeriodEnum datePeriod : DatePeriodEnum.values()) {
            initHashMap.put(datePeriod.code, datePeriod);
        }
    }
}

