/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.enums;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;

public enum TSCErrorCodeEnum {
    SUCCESS("0", "success"),
    INTERNAL_ERROR("1", "internal error"),
    PARAM_ERROR("101000", "param error"),
    PARAM_INVALID("101001", "param invalid"),
    PARAM_OVER_LIMIT("101002", "param over limit"),
    PARAM_MISS("101003", "param miss"),
    PARAM_TYPE_MISMATCH("101004", "param type mismatch"),
    PARAM_VERIFICATION_FAILED("101005", "param verification failed"),
    AUTH_ERROR("102000", "auth error"),
    TOKEN_EXPIRE("102001", "token expire"),
    BAD_TOKEN("102002", "bad token"),
    TOKEN_MISS("102003", "token miss"),
    USERNAME_OR_PASSWORD_INCORRECT("102004", "username or password incorrect"),
    PERMISSION_DENIED("102005", "permission denied"),
    REQUEST_FORBIDDEN("102006", "request forbidden"),
    FOR_SERVER_SAFE("103000", "for server safe"),
    REQUEST_FREQUENTLY("103001", "request frequently"),
    PROCESS_TIMEOUT("103002", "process timeout"),
    SERVER_BUSY("103003", "server busy"),
    HTTP_METHOD_ERROR("103004", "http method error"),
    BUSINESS_ERROR("104000", "business error"),
    USER_NOT_FOUND("104001", "user not found"),
    DATA_NOT_FOUND("104002", "data not found"),
    BAD_DATA("104003", "bad data"),
    OPERATION_FAILED("104004", "operation failed");

    private final String code;
    private final String message;
    private static ConcurrentHashMap<String, TSCErrorCodeEnum> codeMap;
    private static final Object LOCK;

    private TSCErrorCodeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLangMessage() {
        String msg = ResManager.loadKDString((String)this.getMessage(), (String)("TSCErrorCodeMessage_" + this.code), (String)"tsc-tsrbd-common", (Object[])new Object[0]);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCodeMapIfNull() {
        if (codeMap != null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (codeMap != null) {
                return;
            }
            codeMap = new ConcurrentHashMap();
            for (TSCErrorCodeEnum value : TSCErrorCodeEnum.values()) {
                codeMap.put(value.code, value);
            }
        }
    }

    public static TSCErrorCodeEnum codeOf(String code) {
        TSCErrorCodeEnum.initCodeMapIfNull();
        return codeMap.get(code);
    }

    public static String getLangMessage(String code, String defMsg) {
        TSCErrorCodeEnum.initCodeMapIfNull();
        TSCErrorCodeEnum errorCode = codeMap.get(code);
        if (errorCode == null) {
            return defMsg;
        }
        return errorCode.getLangMessage();
    }

    static {
        LOCK = new Object();
    }
}

