/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.utils;

import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.function.UnaryOperator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;

public class DateUtils {
    public static final String DEFAULT_DATE_PATTERN_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_PATTERN_TIME_1 = "yyyy-MM-dd HH:mm";
    public static final String DEFAULT_DATE_YYYY_MM_DD = "yyyy-MM-dd";

    public static LocalDate getByPeriod(DatePeriodEnum datePeriodEnum) {
        if (null == datePeriodEnum) {
            return null;
        }
        UnaryOperator<LocalDate> function = datePeriodEnum.getFunction();
        return (LocalDate)function.apply(LocalDate.now());
    }

    public static String getDayStartTime(LocalDate localDate) {
        if (null == localDate) {
            return "";
        }
        return localDate + " " + "00:00:00";
    }

    public static String getDayEndTime(LocalDate localDate) {
        if (null == localDate) {
            return "";
        }
        return localDate + " " + "23:59:59";
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        sb.append(':');
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        sb.append(':');
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
        return sb.toString();
    }

    public static Date nowDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date afterNowDateTime(int day) {
        return HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getNowDateTime(), (long)day);
    }

    public static Date afterNowDate(int day) {
        LocalDate localDate = LocalDate.now();
        localDate = localDate.plusDays(day);
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        Instant instant1 = zonedDateTime.toInstant();
        return Date.from(instant1);
    }

    public static int getSecondsOfDay(LocalDateTime localDateTime) {
        return 3600 * localDateTime.getHour() + 60 * localDateTime.getMinute() + localDateTime.getSecond();
    }

    public static LocalDateTime getLocalDateTimeByDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static Date getDateByLocalDateTime(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime getCurWeekSunday(LocalDateTime localDateTime) {
        LocalDateTime sundayOfOffset = DateUtils.getSundayOfOffset(localDateTime, 1);
        return sundayOfOffset.withHour(23).withMinute(59).withSecond(59);
    }

    public static LocalDateTime getNextWeekSunday(LocalDateTime localDateTime) {
        LocalDateTime sundayOfOffset = DateUtils.getSundayOfOffset(localDateTime, 2);
        return sundayOfOffset.withHour(23).withMinute(59).withSecond(59);
    }

    public static LocalDateTime getSundayOfOffset(LocalDateTime localDateTime, int offset) {
        DayOfWeek dayOfWeek = localDateTime.getDayOfWeek();
        return localDateTime.plusDays(7L * (long)offset - (long)dayOfWeek.getValue());
    }

    public static LocalDate getLocalDateByDate(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static String formatDate(Date date, String format) {
        if (Objects.isNull(date)) {
            return null;
        }
        SimpleDateFormat dateFormat = null;
        dateFormat = StringUtils.isEmpty((Object)format) ? new SimpleDateFormat(DEFAULT_DATE_PATTERN_TIME) : new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date getMaxWithCurSysDate(Date date) {
        if (Objects.isNull(date)) {
            return new Date();
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime localDateTimeByDate = DateUtils.getLocalDateTimeByDate(date);
        if (localDateTimeByDate.isAfter(LocalDateTime.now())) {
            return date;
        }
        return DateUtils.getDateByLocalDateTime(now);
    }

    public static Date addTimeForDate(Date date) {
        LocalDate localDate = DateUtils.getLocalDateByDate(date);
        if (Objects.isNull(localDate)) {
            return null;
        }
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.now());
        return DateUtils.getDateByLocalDateTime(dateTime);
    }

    public static Boolean isAfter(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return DateUtils.getLocalDateTimeByDate(date).isAfter(LocalDateTime.now());
    }

    public static Boolean isBefore(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return DateUtils.getLocalDateTimeByDate(date).isBefore(LocalDateTime.now());
    }

    public static Date addOneDay(Date date) {
        if (Objects.isNull(date)) {
            return new Date();
        }
        LocalDate localDateByDate = DateUtils.getLocalDateByDate(date);
        LocalDate localDate = localDateByDate.plusDays(1L);
        return DateUtils.getDateByLocalDateTime(LocalDateTime.of(localDate, LocalTime.MIN));
    }

    public static Date editDate(Date date, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar.getTime();
    }

    public static Date convertDate2UserDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(DEFAULT_DATE_PATTERN_TIME);
        formatter.setTimeZone(KDDateUtils.getUserTimeZone());
        String format = formatter.format(date);
        try {
            return new SimpleDateFormat(DEFAULT_DATE_PATTERN_TIME).parse(format);
        }
        catch (Exception e) {
            throw new KDBizException("convertDate2UserDate fail");
        }
    }

    public static boolean compareDate(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        if (calendar1.get(1) > calendar2.get(1)) {
            return true;
        }
        if (calendar1.get(1) < calendar2.get(1)) {
            return false;
        }
        if (calendar1.get(2) > calendar2.get(2)) {
            return true;
        }
        if (calendar1.get(2) < calendar2.get(2)) {
            return false;
        }
        return calendar1.get(5) >= calendar2.get(5);
    }
}

