/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.utils;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class PageUtils {
    public static String getPageId(String businessObjId, String appId, String pageNum, String rootPageId) {
        long currUserId = RequestContext.get().getCurrUserId();
        String globalSessionId = RequestContext.get().getGlobalSessionId();
        StringBuilder pageId = new StringBuilder(String.valueOf(currUserId));
        pageId.append(businessObjId);
        pageId.append(globalSessionId);
        pageId.append(appId);
        pageId.append(pageNum);
        pageId.append(rootPageId);
        return pageId.toString();
    }

    public static void showErrorNotificationAndClosePage(IFormView mainView, IFormView currentView, IFormView closeView, String desc) {
        if (desc.trim().length() > 0) {
            mainView.showErrorNotification(desc);
            currentView.sendFormAction(mainView);
            closeView.close();
            if (!StringUtils.equals((CharSequence)currentView.getPageId(), (CharSequence)closeView.getPageId())) {
                currentView.sendFormAction(closeView);
            }
        }
    }

    public static void setFlexCollapsible(List<String> flexKeyList, boolean collapsible, IFormView view) {
        for (String flexKey : flexKeyList) {
            Container flex = (Container)view.getControl(flexKey);
            flex.setCollapse(collapsible);
        }
    }

    private PageUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void setLabelText(IFormView formView, String labelKey, String text) {
        Label label;
        if (HRStringUtils.isNotEmpty((String)labelKey) && text != null && (label = (Label)formView.getControl(labelKey)) != null) {
            label.setText(text);
        }
    }

    public static IFormView getParentView(IFormView currView) {
        if (currView == null) {
            return null;
        }
        String parentPageId = currView.getFormShowParameter().getParentPageId();
        return currView.getViewNoPlugin(parentPageId);
    }
}

