/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class PermissionServiceUtils {
    private static final Log logger = LogFactory.getLog(PermissionServiceUtils.class);
    private static String KEY_AES256 = "STANDARD-AES-256";

    public static void getSchemeId() {
        Long schemeId = 0L;
        List schemes = PermissionServiceHelper.getSchemes();
        logger.info("getSchemeId.SCHEMEID\uff1a{}", (Object)schemes);
        List ids = schemes.stream().filter(scheme -> KEY_AES256.equals(scheme.getString("number"))).map(entry -> entry.getLong("id")).collect(Collectors.toList());
        IAppCache appCache = AppCache.get((String)"permission.schemeId");
        if (CollectionUtils.isNotEmpty(ids)) {
            schemeId = (Long)ids.get(0);
        }
        appCache.put("schemeId", (Object)schemeId);
    }

    public static String encryptData(String data) {
        IAppCache appCache = AppCache.get((String)"permission.schemeId");
        Long schemeId = (Long)appCache.get("schemeId", Long.class);
        if (null == schemeId) {
            PermissionServiceUtils.getSchemeId();
            schemeId = (Long)appCache.get("schemeId", Long.class);
        }
        logger.info("encryptData.SCHEMEID\uff1a{}", (Object)schemeId);
        if (0L != schemeId) {
            try {
                JSONObject jsonObject = PermissionServiceHelper.encryptData((long)schemeId, (String)data);
                logger.info("encryptData.jsonObject\uff1a{}", (Object)jsonObject);
                if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
                    return jsonObject.get((Object)"data").toString();
                }
            }
            catch (Exception e) {
                logger.error("encryptData fail", (Throwable)e);
                return data;
            }
        }
        return data;
    }

    public static String decryptData(String data) {
        IAppCache appCache = AppCache.get((String)"permission.schemeId");
        Long schemeId = (Long)appCache.get("schemeId", Long.class);
        if (null == schemeId) {
            PermissionServiceUtils.getSchemeId();
            schemeId = (Long)appCache.get("schemeId", Long.class);
        }
        logger.info("decryptData.SCHEMEID\uff1a{}", (Object)schemeId);
        if (0L != schemeId) {
            try {
                JSONObject jsonObject = PermissionServiceHelper.decryptData((long)schemeId, (String)data);
                logger.info("encryptData.decryptData\uff1a{}", (Object)jsonObject);
                if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
                    return jsonObject.get((Object)"data").toString();
                }
            }
            catch (Exception e) {
                logger.error("decryptData fail", (Throwable)e);
                return data;
            }
        }
        return data;
    }
}

