/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.utils;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;

public class PlaceholderResolver {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String NULL_STR = "null";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    private static PlaceholderResolver defaultResolver = new PlaceholderResolver();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";

    private PlaceholderResolver() {
    }

    private PlaceholderResolver(String placeholderPrefix, String placeholderSuffix) {
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
    }

    public static PlaceholderResolver getDefaultResolver() {
        return defaultResolver;
    }

    public static PlaceholderResolver getResolver(String placeholderPrefix, String placeholderSuffix) {
        return new PlaceholderResolver(placeholderPrefix, placeholderSuffix);
    }

    public String resolve(String content, String ... values) {
        int start = content.indexOf(this.placeholderPrefix);
        if (start == -1) {
            return content;
        }
        int valueIndex = 0;
        StringBuilder result = new StringBuilder(content);
        while (start != -1) {
            int end = result.indexOf(this.placeholderSuffix);
            String replaceContent = values[valueIndex++];
            result.replace(start, end + this.placeholderSuffix.length(), replaceContent);
            start = result.indexOf(this.placeholderPrefix, start + replaceContent.length());
        }
        return result.toString();
    }

    public String resolve(String content, Object[] values) {
        return this.resolve(content, (String[])Stream.of(values).map(String::valueOf).toArray(String[]::new));
    }

    public String resolveByRule(String content, Function<String, String> rule) {
        int start = content.indexOf(this.placeholderPrefix);
        if (start == -1) {
            return content;
        }
        StringBuilder result = new StringBuilder(content);
        while (start != -1) {
            String replaceContent;
            int end = result.indexOf(this.placeholderSuffix, start);
            String placeholder = result.substring(start + this.placeholderPrefix.length(), end);
            String string = replaceContent = placeholder.trim().isEmpty() ? "" : rule.apply(placeholder);
            if (NULL_STR.equals(replaceContent)) {
                replaceContent = "";
            }
            result.replace(start, end + this.placeholderSuffix.length(), replaceContent);
            start = result.indexOf(this.placeholderPrefix, start + replaceContent.length());
        }
        return result.toString();
    }

    public String resolveByMap(String content, Map valueMap) {
        return this.resolveByRule(content, placeholderValue -> String.valueOf(valueMap.get(placeholderValue)));
    }

    public String resolveByProperties(String content, Properties properties) {
        return this.resolveByRule(content, placeholderValue -> properties.getProperty((String)placeholderValue));
    }

    public String resolveByDynamicObject(String content, DynamicObject opDef) {
        return this.resolveByRule(content, placeholderValue -> opDef.getString(placeholderValue));
    }
}

