/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.common.utils.unittest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.hr.hbp.common.util.HRStringUtils;

public class UnitTestUtil {
    private final String appId;
    private Pattern pattern = Pattern.compile(",\"pageId\":\"(.+?)\"");

    public UnitTestUtil(String appId) {
        this.appId = appId;
    }

    public IFormView getView(String params, AbstractJUnitTestPlugIn junit) {
        return this.getView(junit.getView(), params, junit);
    }

    public IFormView getView(IFormView view, String params, AbstractJUnitTestPlugIn junit) {
        return this.getViewByAppId(this.appId, view, params, junit);
    }

    private IFormView getViewByAppId(String appId, IFormView view, String params, AbstractJUnitTestPlugIn junit) {
        String pageId = this.getPageIdByAppId(appId, view.getPageId(), params, junit);
        junit.loadData(pageId);
        IFormView returnView = junit.getView(pageId);
        returnView.getFormShowParameter().setAppId(appId);
        return returnView;
    }

    public String invokeAction(String params, AbstractJUnitTestPlugIn junit) {
        return this.invokeAction(junit.getView(), params, junit);
    }

    public String invokeAction(IFormView view, String params, AbstractJUnitTestPlugIn junit) {
        return this.invokeActionForAppId(this.appId, view.getPageId(), params, junit);
    }

    public String invokeActionForAppId(String appId, String currentPageId, String params, AbstractJUnitTestPlugIn junit) {
        return this.checkInfo("" + DispatchServiceHelper.invokeBOSService((String)appId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{currentPageId, params}));
    }

    public String getPageId(String params, AbstractJUnitTestPlugIn junit) {
        return this.getPageId(junit.getView(), params, junit);
    }

    public String getPageId(IFormView view, String params, AbstractJUnitTestPlugIn junit) {
        return this.getPageIdByAppId(this.appId, view, params, junit);
    }

    public String getPageIdByAppId(String appId, IFormView view, String params, AbstractJUnitTestPlugIn junit) {
        return this.getPageIdByAppId(appId, view.getPageId(), params, junit);
    }

    public String getPageIdByAppId(String appId, String params, AbstractJUnitTestPlugIn junit) {
        return this.getPageIdByAppId(appId, junit.getView().getPageId(), params, junit);
    }

    public String getPageIdByAppId(String appId, String currentPageId, String params, AbstractJUnitTestPlugIn junit) {
        String callBackArg = this.invokeActionForAppId(appId, currentPageId, params, junit);
        return this.getPageIdFromCallBackArg(callBackArg);
    }

    public String execute(String pageId, String params, AbstractJUnitTestPlugIn junit) {
        String callBackArg = this.invokeAction(pageId, params, junit);
        return this.getPageIdFromCallBackArg(callBackArg);
    }

    public String invokeAction(String pageId, String params, AbstractJUnitTestPlugIn junit) {
        return junit.getFormService().batchInvokeAction(pageId, params);
    }

    private String checkInfo(String info) {
        if (Pattern.matches(".*error.*", info)) {
            throw new RuntimeException(info);
        }
        return info;
    }

    public void release(String pageId, AbstractJUnitTestPlugIn junit) {
        this.invokeActionForAppId(this.appId, pageId, "[{\"key\":\"\",\"methodName\":\"release\",\"args\":[{}],\"postData\":[]}]", junit);
    }

    public void release(String appId, String pageId, AbstractJUnitTestPlugIn junit) {
        this.invokeActionForAppId(appId, pageId, "[{\"key\":\"\",\"methodName\":\"release\",\"args\":[{}],\"postData\":[]}]", junit);
    }

    public String getPageIdFromCallBackArg(String callBackArg) {
        Matcher matcher;
        String pageId = "";
        List results = (List)SerializationUtils.fromJsonString((String)callBackArg, List.class);
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            for (int j = 0; j < result.size(); ++j) {
                Map map;
                String pageId_1;
                if (!(result.get(j) instanceof Map) || (pageId_1 = (String)(map = (Map)result.get(j)).get("pageId")) == null) continue;
                pageId = pageId_1;
            }
        }
        if (HRStringUtils.isEmpty((String)pageId) && (matcher = this.pattern.matcher(callBackArg)).find()) {
            pageId = matcher.group(1);
        }
        return pageId;
    }

    public String getCallBackPageIdFromCallBackArg(String callBackArg, Set<String> ignorePageIdSet) {
        String pageId = "";
        List results = (List)SerializationUtils.fromJsonString((String)callBackArg, List.class);
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            for (int j = 0; j < result.size(); ++j) {
                Map map;
                String findPageId;
                if (!(result.get(j) instanceof Map) || this.isIgnorePageId(findPageId = (String)(map = (Map)result.get(j)).get("pageId"), ignorePageIdSet)) continue;
                pageId = findPageId;
            }
        }
        if (HRStringUtils.isEmpty((String)pageId)) {
            Matcher matcher = this.pattern.matcher(callBackArg);
            while (matcher.find()) {
                String temp = matcher.group();
                boolean ifIgnore = false;
                for (String ignorePageId : ignorePageIdSet) {
                    if (!HRStringUtils.equalsIgnoreCase((String)temp, (String)ignorePageId)) continue;
                    ifIgnore = true;
                    break;
                }
                if (ifIgnore) continue;
                pageId = temp;
            }
        }
        return pageId;
    }

    private boolean isIgnorePageId(String findPageId, Set<String> ignorePageIdSet) {
        boolean ifIgnore = false;
        for (String ignorePageId : ignorePageIdSet) {
            if (!HRStringUtils.equalsIgnoreCase((String)findPageId, (String)ignorePageId)) continue;
            ifIgnore = true;
            break;
        }
        return ifIgnore;
    }
}

