/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.application.external.invoke;

import java.util.function.Function;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tsc.tsrbd.business.application.external.invoke.InvokeParam;
import org.apache.commons.lang3.time.StopWatch;

public class InvokeHandler<T> {
    private static final Log logger = LogFactory.getLog(InvokeHandler.class);
    private static final InvokeHandler invokeHandler = new InvokeHandler();

    private InvokeHandler() {
    }

    public static InvokeHandler getInstance() {
        return invokeHandler;
    }

    public T invokeService(InvokeParam invokeParam, Object ... param) {
        return this.invokeService(param).apply(invokeParam);
    }

    private Function<InvokeParam, T> invokeService(Object ... param) {
        return invokeParam -> {
            StopWatch stopWatch = new StopWatch(invokeParam.getMethodId());
            try {
                stopWatch.start();
                logger.info("InvokeHandler start invoke {}", (Object)invokeParam.getMethodId());
                Object object = HRMServiceHelper.invokeBizService((String)invokeParam.getCloudId(), (String)invokeParam.getAppId(), (String)invokeParam.getServiceId(), (String)invokeParam.getMethodId(), (Object[])param);
                return object;
            }
            catch (Exception e) {
                logger.error("InvokeHandler Invoke {} error", (Object)invokeParam.getMethodId(), (Object)e);
            }
            finally {
                stopWatch.stop();
                logger.info("InvokeHandler finish invoke {} cost time : {}", (Object)invokeParam.getMethodId(), (Object)stopWatch.getNanoTime());
            }
            return null;
        };
    }
}

