/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Hyperlink;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class EmailConfigService {
    private static final String APP_KEY = "tsrbs";
    private static EmailConfigService service = new EmailConfigService();

    private EmailConfigService() {
    }

    public static EmailConfigService getInstance() {
        return service;
    }

    public DynamicObject getMailConfigBySuffixAndProtocoltype(String suffix, String protocoltype) {
        String catchKey = "tsrbd_cfgmailprop" + suffix + protocoltype;
        String emailConfigString = (String)HRAppCache.get((String)APP_KEY).get(catchKey, String.class);
        if (!HRStringUtils.isEmpty((String)emailConfigString)) {
            return (DynamicObject)SerializationUtils.fromJsonString((String)emailConfigString, DynamicObject.class);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmailprop");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter suffixFilter = new QFilter("suffix", "=", (Object)suffix);
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)protocoltype);
        DynamicObject emailConfig = serviceHelper.queryOne("authurl,isuseauthcode,protocoltype,issyspreset,isusessl,port,serveraddr,suffix", new QFilter[]{enableFilter, suffixFilter, protocolTypeFilter});
        return emailConfig;
    }

    public void setEmailConfig(IFormView view, String type) {
        IDataModel model = view.getModel();
        String emailAddr = (String)model.getValue("emailaddr");
        String protocolType = (String)model.getValue("protocoltype");
        if (HRStringUtils.isEmpty((String)emailAddr) || HRStringUtils.isEmpty((String)protocolType)) {
            return;
        }
        String[] split = emailAddr.split("@");
        if (split.length == 1) {
            return;
        }
        String suffix = "@" + split[1];
        DynamicObject emailConfig = this.getMailConfigBySuffixAndProtocoltype(suffix, protocolType);
        if (emailConfig == null) {
            this.setDefaultConfig(view, model, suffix, protocolType);
            return;
        }
        String serverAddress = emailConfig.getString("serveraddr");
        String port = emailConfig.getString("port");
        boolean useSSL = emailConfig.getBoolean("isusessl");
        if (HRStringUtils.equals((String)"modify", (String)type)) {
            model.setValue("serveraddr", (Object)serverAddress);
            model.setValue("port", (Object)port);
            model.setValue("isusessl", (Object)useSSL);
        }
        this.setMailPasswordTips(emailConfig, view);
    }

    private void setDefaultConfig(IFormView view, IDataModel model, String suffix, String protocolType) {
        view.setVisible(Boolean.FALSE, new String[]{"tipslink"});
        model.setValue("serveraddr", (Object)(protocolType + suffix));
        boolean useSSL = (Boolean)model.getValue("isusessl");
        if (useSSL) {
            if (HRStringUtils.equals((String)"imap", (String)protocolType)) {
                model.setValue("port", (Object)993);
            } else {
                model.setValue("port", (Object)995);
            }
        } else if (HRStringUtils.equals((String)"imap", (String)protocolType)) {
            model.setValue("port", (Object)143);
        } else {
            model.setValue("port", (Object)110);
        }
    }

    public void setMailPasswordTips(DynamicObject mailConfig, IFormView view) {
        boolean useAuthCode = mailConfig.getBoolean("isuseauthcode");
        String authUrl = mailConfig.getString("authurl");
        if (useAuthCode) {
            view.setVisible(Boolean.TRUE, new String[]{"tipslink"});
            Hyperlink hyperlink = (Hyperlink)view.getControl("tipslink");
            hyperlink.setUrl(authUrl);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"tipslink"});
        }
    }

    public void saveEmailConfig(DynamicObject emailInfo) {
        String emailAddress = emailInfo.getString("emailaddr");
        String serverAddress = emailInfo.getString("serveraddr");
        String protocolType = emailInfo.getString("protocoltype");
        String port = emailInfo.getString("port");
        String useSSL = emailInfo.getString("isusessl");
        String suffix = "@" + emailAddress.split("@")[1];
        Long userId = TSCRequestContext.getUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmailprop");
        DynamicObject emailConfig = serviceHelper.generateEmptyDynamicObject();
        emailConfig.set("suffix", (Object)suffix);
        emailConfig.set("port", (Object)port);
        emailConfig.set("isusessl", (Object)useSSL);
        emailConfig.set("protocoltype", (Object)protocolType);
        emailConfig.set("serveraddr", (Object)serverAddress);
        emailConfig.set("status", (Object)"C");
        emailConfig.set("enable", (Object)"1");
        emailConfig.set("creator", (Object)userId);
        emailConfig.set("createtime", (Object)new Date());
        serviceHelper.saveOne(emailConfig);
    }
}

