/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.message.RecycleResumeMessageServiceHelper;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleTaskInfo;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class EmailInfoServiceHelper {
    public static DynamicObject[] getEmailInfo() {
        QFilter mailStatusFilter = new QFilter("mailstatus", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return EmailInfoServiceHelper.getEmailInfo(new QFilter[]{mailStatusFilter, enableFilter});
    }

    public static DynamicObject[] getEmailInfo(QFilter[] qFilters) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
        DynamicObject[] mailInfos = serviceHelper.loadDynamicObjectArray(qFilters);
        return mailInfos;
    }

    public static void resolveErrorMailInfo(List<RecycleTaskInfo> taskInfoList) {
        ArrayList mailInfoList = Lists.newArrayListWithExpectedSize((int)taskInfoList.size());
        HashMap errorCunt = Maps.newHashMapWithExpectedSize((int)taskInfoList.size());
        taskInfoList.forEach(taskInfo -> {
            String taskStatus = taskInfo.getTaskStatus();
            if (HRStringUtils.equals((String)taskStatus, (String)"-2")) {
                DynamicObject mailInfo = taskInfo.getMailInfo();
                mailInfo.set("mailstatus", (Object)"0");
                mailInfoList.add(mailInfo);
                long creator = mailInfo.getLong("creator.id");
                Integer cunt = (Integer)errorCunt.get(creator);
                if (cunt != null) {
                    cunt = cunt + 1;
                    errorCunt.put(creator, cunt);
                } else {
                    errorCunt.put(creator, 1);
                }
            }
        });
        if (mailInfoList.size() > 0) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
            serviceHelper.save(mailInfoList.toArray(new DynamicObject[0]));
        }
        EmailInfoServiceHelper.sendMailLoginErrorMessage();
    }

    private static void sendMailLoginErrorMessage() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
        QFilter statusFilter = new QFilter("mailstatus", "=", (Object)"0");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] errors = serviceHelper.query("creator,id", new QFilter[]{statusFilter, enableFilter});
        HashMap errorCunt = Maps.newHashMapWithExpectedSize((int)errors.length);
        Arrays.stream(errors).forEach(error -> {
            long creator = error.getLong("creator.id");
            Integer cunt = (Integer)errorCunt.get(creator);
            if (cunt != null) {
                cunt = cunt + 1;
                errorCunt.put(creator, cunt);
            } else {
                errorCunt.put(creator, 1);
            }
        });
        errorCunt.forEach((creator, cunt) -> {
            RecycleResumeMessageServiceHelper.sendMailLoginErrorMessage(creator, cunt);
            RecycleResumeMessageServiceHelper.sendMailLoginErrorEmail(creator);
        });
    }

    public static boolean hasMailAddress(String mailAddress, Long mailId) {
        QFilter addressFilter = new QFilter("emailaddr", "=", (Object)mailAddress);
        QFilter idFilter = new QFilter("id", "!=", (Object)mailId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id", new QFilter[]{addressFilter, idFilter});
        return dys.length > 0;
    }

    @Deprecated
    public static void openMailConfigPage(IFormView view, Long pkId, OperationStatus status, BillOperationStatus billOperationStatus, IFormPlugin plugin) {
        if (pkId == null || pkId == 0L) {
            return;
        }
        Long userId = TSCRequestContext.getUserId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPageId(userId + pkId + view.getPageId());
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setFormId("tsrbd_cfgmail");
        baseShowParameter.setPkId((Object)pkId);
        baseShowParameter.setStatus(status);
        baseShowParameter.setBillStatus(billOperationStatus);
        baseShowParameter.setCloseCallBack(new CloseCallBack(plugin, "mailinfocallback"));
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public static DynamicObject[] getErrorMailInfo(Long userId) {
        QFilter userFilter = new QFilter("creator", "=", (Object)userId);
        QFilter statusFilter = new QFilter("mailstatus", "=", (Object)"0");
        QFilter enableFIlter = new QFilter("enable", "=", (Object)"1");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
        DynamicObject[] dys = serviceHelper.queryOriginalArray("emailaddr, id", new QFilter[]{userFilter, statusFilter, enableFIlter});
        return dys;
    }
}

