/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.EmailInfoServiceHelper;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.UniversalMail;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.protocol.AbstractProtocolEmailService;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.protocol.IMAPProtocolEmailService;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.protocol.POP3ProtocolEmailService;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleTaskInfo;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;

public class MailInfoService {
    private static final Integer MAX_WAIT_TIME = 30000;
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"MailInfoService_ThreadPools");
    private static final Log logger = LogFactory.getLog(MailInfoService.class);
    private AbstractProtocolEmailService service;

    private MailInfoService() {
    }

    public static MailInfoService getInstance() {
        return new MailInfoService();
    }

    public boolean authEmailInfo(DynamicObject mailInfo) {
        this.service = this.getService(mailInfo);
        if (this.service == null) {
            return false;
        }
        return this.service.auth();
    }

    public List<UniversalMail> getRecyleEmail(DynamicObject mailInfo, RecycleTaskInfo taskInfo) throws MessagingException {
        this.service = this.getService(mailInfo);
        List<Object> recyleEmailList = Lists.newArrayListWithExpectedSize((int)16);
        if (this.service != null) {
            recyleEmailList = this.service.getRecyleEmail(taskInfo);
        }
        return recyleEmailList;
    }

    public void close() {
        this.service.colse();
    }

    private AbstractProtocolEmailService getService(DynamicObject mailInfo) {
        String protocolType;
        switch (protocolType = mailInfo.getString("protocoltype")) {
            case "pop3": {
                return new POP3ProtocolEmailService(mailInfo);
            }
            case "imap": {
                return new IMAPProtocolEmailService(mailInfo);
            }
            case "exchange": {
                break;
            }
        }
        return null;
    }

    public void openMailConfigPage(IFormView view, Long pkId, OperationStatus status, BillOperationStatus billOperationStatus, IFormPlugin plugin) {
        if (pkId == null || pkId == 0L) {
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)pkId);
        DynamicObject[] emailInfo = EmailInfoServiceHelper.getEmailInfo(new QFilter[]{idFilter});
        if (emailInfo == null) {
            return;
        }
        DynamicObject mailInfo = emailInfo[0];
        boolean hasPerm = this.checkModifyMailInfoPerm(mailInfo, RequestContext.get().getCurrUserId());
        if (!hasPerm) {
            String errorMessage = ResManager.loadKDString((String)"%s:\u60a8\u6ca1\u6709\u8be5\u90ae\u7bb1\u7ba1\u7406\u6743\u9650\u3002", (String)"MailInfoService_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
            view.showTipNotification(String.format(Locale.ROOT, errorMessage, mailInfo.getString("emailaddr")));
            return;
        }
        Long userId = TSCRequestContext.getUserId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPageId(userId + pkId + view.getPageId());
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setFormId("tsrbd_cfgmail");
        baseShowParameter.setPkId((Object)pkId);
        baseShowParameter.setStatus(status);
        baseShowParameter.setBillStatus(billOperationStatus);
        baseShowParameter.setCloseCallBack(new CloseCallBack(plugin, "mailinfocallback"));
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public void openMailInfoF7List(IFormView view, IFormPlugin plugin, List<QFilter> filters) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setMultiSelect(true);
        listShowParameter.setBillFormId("tsrbd_cfgmailf7");
        listShowParameter.setFormId("bos_listf7");
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("900px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        listShowParameter.setOpenStyle(style);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.getListFilterParameter().setQFilters(filters);
        listShowParameter.setCloseCallBack(new CloseCallBack(plugin, "tsrbd_cfgmailf7"));
        view.showForm((FormShowParameter)listShowParameter);
    }

    public void checkMailInfos(List<Object> mailIdList) {
        QFilter idFilters = new QFilter("id", "in", mailIdList);
        DynamicObject[] emailInfos = EmailInfoServiceHelper.getEmailInfo(new QFilter[]{idFilters});
        HashMap mailInfoMaps = Maps.newHashMapWithExpectedSize((int)emailInfos.length);
        for (DynamicObject emailInfo2 : emailInfos) {
            mailInfoMaps.put(emailInfo2.getLong("id"), emailInfo2);
        }
        Map<Long, Future> futureMap = Arrays.stream(emailInfos).collect(Collectors.toMap(emailInfo -> emailInfo.getLong("id"), emailInfo -> THREAD_POOL.submit(() -> MailInfoService.getInstance().authEmailInfo((DynamicObject)emailInfo))));
        ArrayList mailInfoList = Lists.newArrayListWithExpectedSize((int)emailInfos.length);
        futureMap.forEach((id, future) -> {
            try {
                Boolean result = (Boolean)future.get(MAX_WAIT_TIME.intValue(), TimeUnit.MILLISECONDS);
                DynamicObject dynamicObject = (DynamicObject)mailInfoMaps.get(id);
                if (result.booleanValue()) {
                    dynamicObject.set("mailstatus", (Object)"1");
                } else {
                    dynamicObject.set("mailstatus", (Object)"0");
                }
                mailInfoList.add(dynamicObject);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error((Throwable)e);
            }
        });
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
        serviceHelper.save(mailInfoList.toArray(new DynamicObject[0]));
    }

    public List<Long> getHasPermMailIds(Long userId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"tsrbd", (String)"tsrbd_cfgmail", (String)"47150e89000000ac");
        List hasPermOrgs = result.getHasPermOrgs();
        logger.info("user has perm orgs is {}", (Object)hasPermOrgs);
        if (CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
            return hasPermOrgs;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_cfgmail", (List)hasPermOrgs, (boolean)false);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
        DynamicObject[] dys = serviceHelper.query("id", new QFilter[]{baseDataFilter});
        return Arrays.stream(dys).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getHasPermMailIdsWithOrg(Long orgId) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_cfgmail", (Long)orgId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_cfgmail");
        DynamicObject[] dys = serviceHelper.query("id", new QFilter[]{baseDataFilter});
        return Arrays.stream(dys).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }

    public boolean checkModifyMailInfoPerm(DynamicObject dataInfo, long currUserId) {
        List hasPermOrgs;
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (superUser) {
            return true;
        }
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)currUserId, (String)"tsrbd", (String)"tsrbd_cfgmail", (String)"4715a0df000000ac");
        Long manageOrg = this.getManageOrg(dataInfo);
        if (manageOrg == null || manageOrg.equals(0L)) {
            manageOrg = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dataInfo, (String)"createorg");
        }
        if (CollectionUtils.isEmpty((Collection)(hasPermOrgs = result.getHasPermOrgs()))) {
            return false;
        }
        return hasPermOrgs.contains(manageOrg);
    }

    private Long getManageOrg(DynamicObject dataInfo) {
        Long manageOrg = null;
        String Strategy_One = "1";
        String Strategy_Tow = "2";
        DynamicObject bdctrlstrtgy = BaseDataServiceHelper.getCtrlStrtgy((DynamicObject)dataInfo);
        if (bdctrlstrtgy == null) {
            return manageOrg;
        }
        List entrys = (List)bdctrlstrtgy.get("entryentity");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        String managestrategy = (String)entry.get("managestrategy");
        if (Strategy_Tow.equals(managestrategy)) {
            Object cuObj = dataInfo.get("createorg");
            if (cuObj instanceof Long) {
                manageOrg = (Long)cuObj;
            } else if (cuObj instanceof DynamicObject) {
                manageOrg = (Long)((DynamicObject)cuObj).getPkValue();
            }
        } else if (Strategy_One.equals(managestrategy)) {
            Object cuObj = bdctrlstrtgy.get("cu");
            if (cuObj instanceof Long) {
                manageOrg = (Long)cuObj;
            } else if (cuObj instanceof DynamicObject) {
                manageOrg = (Long)((DynamicObject)cuObj).getPkValue();
            }
        }
        return manageOrg;
    }
}

