/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.message;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.message.api.MessageChannels;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.EmailInfoServiceHelper;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.message.MailErrorMessageHtmlTag;

public class RecycleResumeMessageServiceHelper {
    public static void sendMailLoginErrorMessage(Long userId, int errorCunt) {
        MessageInfo message = new MessageInfo();
        message.setType("message");
        message.setTitle(ResManager.loadKDString((String)"\u6536\u53d6\u7b80\u5386\u90ae\u7bb1\u5f02\u5e38\u63d0\u9192", (String)"RecycleResumeMessageServiceHelper_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        ArrayList userIds = Lists.newArrayListWithExpectedSize((int)16);
        userIds.add(userId);
        message.setUserIds((List)userIds);
        HashMap parms = Maps.newHashMapWithExpectedSize((int)16);
        parms.put(MessageChannels.EMAIL.getNumber(), Collections.EMPTY_LIST);
        message.setParams((Map)parms);
        message.setSenderName(ResManager.loadKDString((String)"\u4eba\u624d\u4f9b\u5e94\u4e91", (String)"RecycleResumeMessageServiceHelper_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        message.setSenderId(Long.valueOf(UserServiceHelper.getCurrentUserId()));
        message.setTag(ResManager.loadKDString((String)"\u90ae\u7bb1\u8d26\u53f7\u5f02\u5e38", (String)"RecycleResumeMessageServiceHelper_2", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        message.setContent(ResManager.loadKDString((String)String.format(Locale.ROOT, "%s\u4e2a\u6536\u53d6\u7b80\u5386\u7684\u90ae\u7bb1\u5f02\u5e38\uff0c\u62db\u8058\u7f51\u7ad9\u7684\u5019\u9009\u4eba\u7b80\u5386\u65e0\u6cd5\u81ea\u52a8\u8fdb\u5165\u7cfb\u7edf\uff0c\u8bf7\u5c3d\u5feb\u53bb\u5904\u7406\uff01", errorCunt), (String)"RecycleResumeMessageServiceHelper_3", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        String contentUrl = UrlService.getDomainContextUrl() + "/?formId=tsrbd_cfgerrormail&type=list&list_formId=bos_list";
        message.setContentUrl(contentUrl);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static void sendMailLoginErrorEmail(Long userId) {
        Map userInfoMap = UserServiceHelper.getUserInfoByID((long)userId);
        if (userInfoMap == null || userInfoMap.isEmpty()) {
            return;
        }
        String mailAddress = (String)userInfoMap.get("email");
        MessageInfo message = new MessageInfo();
        message.setNotifyType(MessageChannels.EMAIL.getNumber());
        HashMap parms = Maps.newHashMapWithExpectedSize((int)16);
        parms.put(MessageChannels.EMAIL.getNumber(), Collections.singletonList(mailAddress));
        message.setParams((Map)parms);
        message.setMessageTitle((ILocaleString)LocaleString.fromMap((Map)ImmutableMap.of((Object)Lang.zh_CN.toString(), (Object)ResManager.loadKDString((String)"\u3010\u91d1\u8776\u4e91\u82cd\u7a79\u3011\u6536\u53d6\u7b80\u5386\u90ae\u7bb1\u5f02\u5e38\u63d0\u9192", (String)"RecycleResumeMessageServiceHelper_4", (String)"tsc-tsrbd-business", (Object[])new Object[0]))));
        message.setMessageContent((ILocaleString)new LocaleString(RecycleResumeMessageServiceHelper.getMailContent(userId)));
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    private static String getMailContent(Long userId) {
        StringBuilder htmlSB = new StringBuilder();
        DynamicObject[] errorMailInfos = EmailInfoServiceHelper.getErrorMailInfo(userId);
        htmlSB.append(MailErrorMessageHtmlTag.getHtml(MailErrorMessageHtmlTag.HEADER, new Object[0]));
        htmlSB.append(MailErrorMessageHtmlTag.getHtml(MailErrorMessageHtmlTag.BODY, errorMailInfos.length));
        for (DynamicObject errorMailInfo : errorMailInfos) {
            htmlSB.append(MailErrorMessageHtmlTag.getHtml(MailErrorMessageHtmlTag.TABLE, errorMailInfo.getString("emailaddr"), ResManager.loadKDString((String)"\u90ae\u7bb1\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef", (String)"RecycleResumeMessageServiceHelper_5", (String)"tsc-tsrbd-business", (Object[])new Object[0])));
        }
        String contentUrl = UrlService.getDomainContextUrl() + "/?formId=bos_list&type=list&billFormId=tsrbd_cfgerrormail&isIgnoreLicense=true";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        htmlSB.append(MailErrorMessageHtmlTag.getHtml(MailErrorMessageHtmlTag.END, contentUrl, format.format(new Date())));
        return htmlSB.toString();
    }
}

