/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.protocol;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.MailConn;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.MailItem;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.UniversalMail;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.RecycleTaskServiceHelper;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleTaskInfo;

public abstract class AbstractProtocolEmailService {
    private static final Log logger = LogFactory.getLog(AbstractProtocolEmailService.class);
    private DynamicObject mailInfoDyn;
    protected MailConn conn;

    public DynamicObject getMailInfoDyn() {
        return this.mailInfoDyn;
    }

    public AbstractProtocolEmailService(DynamicObject mailInfoDyn) {
        this.mailInfoDyn = mailInfoDyn;
    }

    protected abstract MailConn getConn() throws MessagingException;

    protected abstract List<MailItem> getMessage(MailConn var1) throws MessagingException;

    protected abstract UniversalMail parseMail(MailItem var1, List<String> var2);

    protected abstract String getUID(MimeMessage var1) throws MessagingException;

    public abstract void colse();

    public List<UniversalMail> getRecyleEmail(RecycleTaskInfo taskInfo) throws MessagingException {
        ArrayList universalMailList = Lists.newArrayListWithExpectedSize((int)16);
        try {
            this.conn = this.getConn();
        }
        catch (MessagingException e) {
            logger.error((Throwable)e);
            logger.error("get conn error!");
            taskInfo.setTaskStatus("-2");
            return universalMailList;
        }
        List<String> existUids = this.getExistUids();
        List<MailItem> mailItems = this.getMessage(this.conn);
        mailItems.forEach(mailItem -> {
            UniversalMail universalMail = this.parseMail((MailItem)mailItem, existUids);
            if (universalMail != null) {
                universalMailList.add(universalMail);
            }
        });
        return universalMailList;
    }

    public boolean auth() {
        try {
            this.conn = this.getConn();
        }
        catch (MessagingException e) {
            logger.error((Throwable)e);
            return false;
        }
        return true;
    }

    protected UniversalMail parseMimeMessage(MimeMessage mimeMessage, List<String> existUids) {
        try {
            String mailAddress = this.mailInfoDyn.getString("emailaddr");
            String uid = this.getUID(mimeMessage);
            if (HRStringUtils.isEmpty((String)uid) || existUids.contains(uid)) {
                logger.error("exist uid is : {}", (Object)uid);
                logger.error("this message has not parse!");
                return null;
            }
            String subject = mimeMessage.getSubject();
            subject = subject.replaceAll("\u2014", "-");
            subject = subject.replaceAll("\uff0d", "-");
            subject = subject.replaceAll("\uff08", "(");
            subject = subject.replaceAll("\uff09", ")");
            Object conent = mimeMessage.getContent();
            Date sendDate = mimeMessage.getSentDate();
            String fromAddress = "";
            Address[] addresses = mimeMessage.getFrom();
            if (addresses != null && addresses.length > 0) {
                fromAddress = ((InternetAddress)addresses[0]).getAddress();
            }
            String folderName = mimeMessage.getFolder().getName();
            UniversalMail universalMail = new UniversalMail();
            universalMail.setTitle(subject);
            universalMail.setContent(conent);
            universalMail.setFolder(folderName);
            universalMail.setFromer(fromAddress);
            universalMail.setSendDate(sendDate);
            universalMail.setUid(uid);
            return universalMail;
        }
        catch (IOException | MessagingException e) {
            logger.error(e);
            logger.error("parse mail error!");
            return null;
        }
    }

    private List<String> getExistUids() {
        DynamicObject[] records = RecycleTaskServiceHelper.getRecordByMailInfo(this.mailInfoDyn.getLong("id"));
        List<String> uidList = Arrays.stream(records).map(record -> record.getString("uid")).collect(Collectors.toList());
        return uidList;
    }
}

