/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.protocol;

import com.google.common.collect.Lists;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.MailConn;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.MailItem;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.UniversalMail;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.protocol.AbstractProtocolEmailService;

public class IMAPProtocolEmailService
extends AbstractProtocolEmailService {
    private static final Log logger = LogFactory.getLog(IMAPProtocolEmailService.class);
    private static final String PROPS_HOST = "mail.imap.host";
    private static final String PROPS_PORT = "mail.imap.port";
    private static final String PROPS_SSL = "mail.imap.ssl.enable";
    private static final String PROPS_AUTH = "mail.imap.auth";

    public IMAPProtocolEmailService(DynamicObject mailInfoDyn) {
        super(mailInfoDyn);
    }

    @Override
    protected MailConn getConn() throws MessagingException {
        return new MailConn();
    }

    @Override
    protected List<MailItem> getMessage(MailConn mailConn) throws MessagingException {
        Date recycleDate = this.getMailInfoDyn().getDate("recyledate");
        String mailAddress = this.getMailInfoDyn().getString("emailaddr");
        logger.info("{} recycleDate is :{}", (Object)mailAddress, (Object)recycleDate);
        boolean flag = true;
        if (recycleDate == null) {
            flag = false;
        }
        IMAPStore store = mailConn.getImapStore();
        IMAPFolder folder = (IMAPFolder)store.getFolder("INBOX");
        folder.open(1);
        Message[] messages = folder.getMessages();
        ArrayList mailItemList = Lists.newArrayListWithExpectedSize((int)messages.length);
        for (Message message : messages) {
            try {
                Date receivedDate = message.getReceivedDate();
                if (flag && (receivedDate == null || receivedDate.before(recycleDate))) {
                    logger.info("{} message receivedDate is :{}", (Object)mailAddress, (Object)receivedDate);
                    logger.info("message title is:{}", (Object)message.getSubject());
                    continue;
                }
                MailItem mailItem = new MailItem();
                mailItem.setImapMessage((IMAPMessage)message);
                mailItemList.add(mailItem);
            }
            catch (MessagingException exception) {
                logger.error("get message has some error!");
                logger.error((Throwable)exception);
            }
        }
        return mailItemList;
    }

    @Override
    protected UniversalMail parseMail(MailItem mailItem, List<String> existUids) {
        return this.parseMimeMessage((MimeMessage)mailItem.getImapMessage(), existUids);
    }

    @Override
    protected String getUID(MimeMessage mimeMessage) throws MessagingException {
        Folder folder = mimeMessage.getFolder();
        long uid = ((IMAPFolder)folder).getUID((Message)mimeMessage);
        String folderName = folder.getName();
        String mailAddress = this.getMailInfoDyn().getString("emailaddr");
        String UID = HRStringUtils.isEmpty((String)folderName) ? "folder" + uid : folderName + uid;
        return mailAddress + "-" + UID;
    }

    @Override
    public void colse() {
        if (this.conn != null) {
            try {
                this.conn.getImapStore().close();
            }
            catch (MessagingException e) {
                logger.debug("store close error");
            }
        }
    }
}

