/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.protocol;

import com.google.common.collect.Lists;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.POP3Message;
import com.sun.mail.pop3.POP3Store;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.MailConn;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.MailItem;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.domain.UniversalMail;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.protocol.AbstractProtocolEmailService;

public class POP3ProtocolEmailService
extends AbstractProtocolEmailService {
    private static final Log logger = LogFactory.getLog(POP3ProtocolEmailService.class);
    private static final String PROPS_HOST = "mail.pop3.host";
    private static final String PROPS_PORT = "mail.pop3.port";
    private static final String PROPS_SSL = "mail.pop3.ssl.enable";
    private static final String PROPS_AUTH = "mail.pop3.auth";

    public POP3ProtocolEmailService(DynamicObject mailInfoDyn) {
        super(mailInfoDyn);
    }

    @Override
    protected MailConn getConn() throws MessagingException {
        return new MailConn();
    }

    @Override
    protected List<MailItem> getMessage(MailConn mailConn) throws MessagingException {
        Date recyleDate = this.getMailInfoDyn().getDate("recyledate");
        boolean flag = true;
        if (recyleDate == null) {
            flag = false;
        }
        POP3Store store = mailConn.getPop3Store();
        POP3Folder folder = (POP3Folder)store.getFolder("INBOX");
        folder.open(1);
        Message[] messages = folder.getMessages();
        ArrayList mailItemList = Lists.newArrayListWithExpectedSize((int)messages.length);
        for (Message message : messages) {
            boolean isFlagAndBefore;
            Date receivedDate = message.getSentDate();
            boolean bl = isFlagAndBefore = flag && (receivedDate == null || receivedDate.before(recyleDate));
            if (isFlagAndBefore) {
                logger.info(" message receivedDate is :{}", (Object)receivedDate);
                logger.info("message title is:{}", (Object)message.getSubject());
                continue;
            }
            MailItem mailItem = new MailItem();
            mailItem.setPop3Message((POP3Message)message);
            mailItemList.add(mailItem);
        }
        return mailItemList;
    }

    @Override
    protected UniversalMail parseMail(MailItem mailItem, List<String> existUids) {
        return this.parseMimeMessage((MimeMessage)mailItem.getPop3Message(), existUids);
    }

    @Override
    protected String getUID(MimeMessage mimeMessage) throws MessagingException {
        Folder folder = mimeMessage.getFolder();
        String mailAddress = this.getMailInfoDyn().getString("emailaddr");
        String UID = ((POP3Folder)folder).getUID((Message)mimeMessage);
        return mailAddress + "-" + UID;
    }

    @Override
    public void colse() {
        if (this.conn != null) {
            try {
                this.conn.getPop3Store().close();
            }
            catch (MessagingException e) {
                logger.debug("store close error");
            }
        }
    }
}

