/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.email.MailInfoService;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.MailRecycleCount;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleResumeRecord;
import kd.tsc.tsrbd.business.domain.basedata.service.recycleresume.recycle.domain.RecycleTaskInfo;

public class RecycleTaskServiceHelper {
    private static final Log logger = LogFactory.getLog(RecycleTaskServiceHelper.class);

    public static void saveTask(List<RecycleTaskInfo> taskInfoList, List<RecycleResumeRecord> recordList) {
        logger.info("taskInfoList size is {}", (Object)taskInfoList.size());
        logger.info("recordList size is {}", (Object)recordList.size());
        logger.info("recordList is {}", recordList);
        RecycleTaskServiceHelper.saveRecycleTaskInfo(taskInfoList);
        RecycleTaskServiceHelper.saveRecycleResumeRecord(recordList);
    }

    public static void saveRecycleTaskInfo(List<RecycleTaskInfo> taskInfoList) {
        if (taskInfoList == null || taskInfoList.size() == 0) {
            return;
        }
        ArrayList taskInfoDynList = Lists.newArrayListWithExpectedSize((int)taskInfoList.size());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recycletask");
        taskInfoList.forEach(taskInfo -> {
            DynamicObject taskInfoDyn = serviceHelper.generateEmptyDynamicObject();
            taskInfoDyn.set("id", (Object)taskInfo.getTaskId());
            taskInfoDyn.set("startdate", (Object)taskInfo.getStartDate());
            taskInfoDyn.set("enddate", (Object)taskInfo.getEndDate());
            taskInfoDyn.set("sumcunt", (Object)taskInfo.getSumCunt());
            taskInfoDyn.set("successcunt", (Object)taskInfo.getSuccessCunt());
            taskInfoDyn.set("faildcunt", (Object)taskInfo.getFaildCunt());
            taskInfoDyn.set("mailinfo", (Object)taskInfo.getMainInfoId());
            taskInfoDyn.set("taskstatus", (Object)taskInfo.getTaskStatus());
            taskInfoDynList.add(taskInfoDyn);
        });
        serviceHelper.save(taskInfoDynList.toArray(new DynamicObject[0]));
    }

    public static void saveRecycleResumeRecord(List<RecycleResumeRecord> recordList) {
        if (recordList == null || recordList.size() == 0) {
            return;
        }
        ArrayList recordDynList = Lists.newArrayListWithExpectedSize((int)recordList.size());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recyclerecord");
        recordList.forEach(record -> {
            String recycleStatus = record.getRecycleStatus();
            logger.info("record status is {}", (Object)recycleStatus);
            logger.info("record tittle is {}", (Object)record.getTitle());
            if (!HRStringUtils.equals((String)"-1", (String)recycleStatus)) {
                DynamicObject recordDyn = serviceHelper.generateEmptyDynamicObject();
                recordDyn.set("taskinfoid", (Object)record.getTaskInfoId());
                recordDyn.set("uid", (Object)record.getUid());
                recordDyn.set("url", (Object)record.getUrl());
                recordDyn.set("title", (Object)record.getTitle());
                recordDyn.set("recyclestatus", (Object)recycleStatus);
                recordDyn.set("mailinfo", (Object)record.getMailInfo());
                recordDyn.set("channel", (Object)record.getChannelId());
                recordDyn.set("rsmid", (Object)record.getRsmId());
                recordDynList.add(recordDyn);
            }
        });
        serviceHelper.save(recordDynList.toArray(new DynamicObject[0]));
    }

    public static DynamicObject[] getRecordByMailInfo(Long mailInfoId) {
        QFilter mailInfoFilter = new QFilter("mailinfo", "=", (Object)mailInfoId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recyclerecord");
        return serviceHelper.queryOriginalArray("id, uid, recyclestatus", new QFilter[]{mailInfoFilter});
    }

    public List<MailRecycleCount> getMailRecycleCount(List<Long> rsmIdList, LocalDate startDate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recyclerecord");
        QFilter statusFilter = new QFilter("recyclestatus", "=", (Object)"1");
        if (startDate != null) {
            List<Long> recycleTaskIds = RecycleTaskServiceHelper.getRecycleTaskIds(startDate);
            statusFilter.and(new QFilter("taskinfoid", "in", recycleTaskIds));
        }
        logger.info("RecycleTaskServiceHelper.getMailRecycleCount.startDate:{}", (Object)startDate);
        logger.info("RecycleTaskServiceHelper.getMailRecycleCount.statusFilter:{}", (Object)statusFilter);
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (!superUser) {
            List<Long> hasPermMailIds = MailInfoService.getInstance().getHasPermMailIds(currUserId);
            QFilter mailFilter = new QFilter("mailinfo", "in", hasPermMailIds);
            statusFilter.and(mailFilter);
        }
        DynamicObject[] dys = serviceHelper.query("mailinfo,channel", new QFilter[]{statusFilter}, "mailinfo.id,channel");
        HashMap resumeCountMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        HashMap mailInfoMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        Map<Long, String> recRuchnlmnMap = this.getRecRuchnlmnMap();
        for (DynamicObject dyn : dys) {
            long mailInfoId = dyn.getLong("mailinfo.id");
            Long channel = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"channel");
            String channelName = recRuchnlmnMap.get(channel);
            mailInfoMap.put(mailInfoId, dyn.getDynamicObject("mailinfo"));
            String key = mailInfoId + "-" + channelName;
            Integer count = (Integer)resumeCountMap.get(key);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            resumeCountMap.put(key, count);
        }
        ArrayList mailRecycleCounts = Lists.newArrayListWithExpectedSize((int)resumeCountMap.size());
        for (Map.Entry entry : resumeCountMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] split = key.split("-");
            Long mailId = Long.parseLong(split[0]);
            String channelName = split[1];
            DynamicObject mailInfo = (DynamicObject)mailInfoMap.get(mailId);
            if (mailInfo == null) continue;
            Integer count = (Integer)entry.getValue();
            MailRecycleCount mailRecycleCount = new MailRecycleCount();
            mailRecycleCount.setMailId(mailId);
            mailRecycleCount.setResumeCount(count);
            mailRecycleCount.setMailAddress(mailInfo.getString("emailaddr"));
            mailRecycleCount.setMailStatus(mailInfo.getString("mailstatus"));
            mailRecycleCount.setSource(channelName);
            mailRecycleCounts.add(mailRecycleCount);
        }
        mailRecycleCounts.sort(Comparator.comparing(MailRecycleCount::getSource));
        mailRecycleCounts.sort(Comparator.comparing(MailRecycleCount::getMailId));
        return mailRecycleCounts;
    }

    public static List<Long> getRecycleTaskIds(LocalDate startDate) {
        QFilter qFilter = new QFilter("createtime", ">=", (Object)startDate);
        DynamicObjectCollection recycleTask = QueryServiceHelper.query((String)"tsrbd_recycletask", (String)"id", (QFilter[])new QFilter[]{qFilter});
        ArrayList<Long> recycleTaskIds = new ArrayList<Long>(16);
        if (recycleTask != null) {
            for (DynamicObject dynObj : recycleTask) {
                recycleTaskIds.add(dynObj.getLong("id"));
            }
        }
        return recycleTaskIds;
    }

    private Map<Long, String> getRecRuchnlmnMap() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recruchnlnm");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("name")));
    }
}

