/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.fieldscm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.fieldscm.CfgMsgTempTypeHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.FieldPoolHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferFieldsHelper;

public class CfgMsgFieldSchemeService {
    private static HRBaseServiceHelper SERVICEHELPER = new HRBaseServiceHelper("tsrbd_msgtempfldscm");
    private static HRBaseServiceHelper OFFERFIELDHELPER = new HRBaseServiceHelper("tsrbd_offerfield");
    private static String FIELDBLOCK_BIZ_OFFERLETTER = "tso_offerletter";
    private Log LOGGER = LogFactory.getLog(CfgMsgFieldSchemeService.class);

    private CfgMsgFieldSchemeService() {
    }

    public static CfgMsgFieldSchemeService getInstance() {
        return new CfgMsgFieldSchemeService();
    }

    public DynamicObjectCollection getMsgTempFieldByScmId(Long scmId) {
        DynamicObject scm = SERVICEHELPER.loadSingle((Object)scmId);
        return scm.getDynamicObjectCollection("entryentity");
    }

    public Map<String, String> getMsgTempFieldMap(Long scmId) {
        DynamicObjectCollection msgTempFieldByScmId = this.getMsgTempFieldByScmId(scmId);
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)msgTempFieldByScmId.size());
        IAppCache appCache = AppCache.get((String)"offerFieldStatus");
        for (DynamicObject dynamicObject : msgTempFieldByScmId) {
            String name = dynamicObject.getString("offerfield.name");
            String number = dynamicObject.getString("offerfield.bizfield");
            String fieldStatus = dynamicObject.getString("fieldstatus");
            appCache.put(number, (Object)fieldStatus);
            result.put(number, name);
        }
        return result;
    }

    public List<String> getMsgTempFieldNumberByGroup(Long scmId, String group) {
        DynamicObjectCollection msgTempFieldByScmId = this.getMsgTempFieldByScmId(scmId);
        ArrayList result = Lists.newArrayListWithCapacity((int)msgTempFieldByScmId.size());
        for (DynamicObject dynamicObject : msgTempFieldByScmId) {
            String fieldGroup = dynamicObject.getString("offerfield.group.number");
            if (!HRStringUtils.equals((String)fieldGroup, (String)group)) continue;
            result.add(dynamicObject.getString("offerfield.bizfield"));
        }
        return result;
    }

    public List<Long> getMsgTempFields(String group) {
        ArrayList<Long> salaryIdList = new ArrayList<Long>();
        QFilter groupFilter = new QFilter("group.number", "=", (Object)group);
        DynamicObject[] dys = OFFERFIELDHELPER.query("bizfield", new QFilter[]{groupFilter});
        List collect = Arrays.stream(dys).map(dyn -> dyn.getString("bizfield")).collect(Collectors.toList());
        for (String s : collect) {
            try {
                salaryIdList.add(Long.valueOf(s));
            }
            catch (Exception e) {
                this.LOGGER.error((Throwable)e);
            }
        }
        return salaryIdList;
    }

    public void syncOfferField(Long tempTypeId) {
        List<Map<String, String>> syncFieldServiceList = CfgMsgTempTypeHelper.getSyncFieldMService(tempTypeId);
        HashMap groupFieldsMap = Maps.newHashMapWithExpectedSize((int)syncFieldServiceList.size());
        HashMap serviceMap = Maps.newHashMapWithExpectedSize((int)syncFieldServiceList.size());
        for (Map<String, String> service : syncFieldServiceList) {
            this.invokeMService(groupFieldsMap, serviceMap, service);
        }
        this.LOGGER.info("groupFieldsMap is {}", (Object)groupFieldsMap);
        this.LOGGER.info("serviceMap is {}", (Object)serviceMap);
        Map<String, Long> fieldBlockMap = FieldPoolHelper.isExistFieldBlock(new ArrayList<String>(groupFieldsMap.keySet()));
        ArrayList blockDynamicList = Lists.newArrayListWithCapacity((int)fieldBlockMap.size());
        ArrayList fieldDynamicList = Lists.newArrayListWithCapacity((int)fieldBlockMap.size());
        ArrayList fieldPoolDynamicList = Lists.newArrayListWithCapacity((int)fieldBlockMap.size());
        HRBaseServiceHelper blockServiceHelper = new HRBaseServiceHelper("tsrbd_fieldblock");
        HRBaseServiceHelper fieldServiceHelper = new HRBaseServiceHelper("tsrbd_offerfield");
        HRBaseServiceHelper fieldPoolServiceHelper = new HRBaseServiceHelper("tsrbd_fieldpool");
        ArrayList payNumberList = Lists.newArrayListWithCapacity((int)8);
        for (Map.Entry entry : groupFieldsMap.entrySet()) {
            Map fields = (Map)entry.getValue();
            String groupKey = (String)entry.getKey();
            Map service = (Map)serviceMap.get(groupKey);
            String groupname = (String)service.get("groupname");
            Long blockId = fieldBlockMap.get(groupKey);
            if (blockId.equals(0L)) {
                blockId = ID.genLongId();
                DynamicObject dynamicObject = blockServiceHelper.generateEmptyDynamicObject();
                dynamicObject.set("number", (Object)groupKey);
                dynamicObject.set("name", (Object)groupname);
                dynamicObject.set("biz", (Object)FIELDBLOCK_BIZ_OFFERLETTER);
                dynamicObject.set("id", (Object)blockId);
                dynamicObject.set("status", (Object)"C");
                dynamicObject.set("enable", (Object)"1");
                blockDynamicList.add(dynamicObject);
            }
            for (Map.Entry<String, String> entry2 : fields.entrySet()) {
                this.assembleDynamicObjects(fieldDynamicList, fieldPoolDynamicList, fieldServiceHelper, fieldPoolServiceHelper, blockId, entry2, payNumberList);
            }
        }
        if (blockDynamicList.size() > 0) {
            blockServiceHelper.save(blockDynamicList.toArray(new DynamicObject[0]));
        }
        if (fieldPoolDynamicList.size() > 0) {
            this.saveDynamicList(fieldPoolDynamicList, fieldPoolServiceHelper);
        }
        if (fieldDynamicList.size() > 0) {
            this.saveDynamicList(fieldDynamicList, fieldServiceHelper);
        }
        Long groupId = 1564605693112209408L;
        DynamicObject[] fieldPoolsByGroupList = OfferFieldsHelper.getFieldpoolsByGroup(groupId);
        this.LOGGER.info("CfgMsgFieldSchemeService.syncOfferField fieldPoolsByGroupList: {} payNumberList : {}", (Object)fieldPoolsByGroupList, (Object)payNumberList);
        FieldPoolHelper.updateEnableStatus(fieldPoolsByGroupList, payNumberList);
    }

    private void saveDynamicList(List<DynamicObject> dynList, HRBaseServiceHelper serviceHelper) {
        List numberList = dynList.stream().map(field -> field.getString("number")).collect(Collectors.toList());
        QFilter numberFilter = new QFilter("number", "in", numberList);
        DynamicObject[] dys = serviceHelper.query("number", new QFilter[]{numberFilter});
        List existNumbers = Arrays.stream(dys).map(dyn -> dyn.getString("number")).collect(Collectors.toList());
        serviceHelper.save((DynamicObject[])dynList.stream().filter(field -> !existNumbers.contains(field.getString("number"))).toArray(DynamicObject[]::new));
    }

    private void assembleDynamicObjects(List<DynamicObject> fieldDynamicList, List<DynamicObject> fieldPoolDynamicList, HRBaseServiceHelper fieldServiceHelper, HRBaseServiceHelper fieldPoolServiceHelper, Long blockId, Map.Entry<String, String> field, List<String> payNumberList) {
        String number = field.getKey();
        String name = field.getValue();
        long fieldPoolId = ORM.create().genLongId("tsrbd_fieldpool");
        DynamicObject fieldPool = fieldPoolServiceHelper.generateEmptyDynamicObject();
        fieldPool.set("number", (Object)number);
        fieldPool.set("name", (Object)name);
        fieldPool.set("fieldkey", (Object)number);
        fieldPool.set("id", (Object)fieldPoolId);
        fieldPool.set("status", (Object)"C");
        fieldPool.set("enable", (Object)"1");
        fieldPoolDynamicList.add(fieldPool);
        DynamicObject fieldDyn = fieldServiceHelper.generateEmptyDynamicObject();
        fieldDyn.set("number", (Object)number);
        fieldDyn.set("name", (Object)name);
        fieldDyn.set("group", (Object)blockId);
        fieldDyn.set("fieldpool", (Object)fieldPool);
        fieldDyn.set("bizfield", (Object)number);
        fieldDyn.set("bizrange", (Object)",0,");
        fieldDyn.set("status", (Object)"C");
        fieldDyn.set("enable", (Object)"1");
        fieldDynamicList.add(fieldDyn);
        payNumberList.add(number);
    }

    private void invokeMService(Map<String, Map<String, String>> groupFieldsMap, Map<String, Map<String, String>> serviceMap, Map<String, String> service) {
        String fieldcloud = service.get("fieldcloud");
        String fieldapp = service.get("fieldapp");
        String fieldservice = service.get("fieldservice");
        String fieldmethod = service.get("fieldmethod");
        String groupkey = service.get("groupkey");
        Map result = Maps.newHashMapWithExpectedSize((int)16);
        try {
            result = (Map)DispatchServiceHelper.invokeBizService((String)fieldcloud, (String)fieldapp, (String)fieldservice, (String)fieldmethod, (Object[])new Object[0]);
        }
        catch (Exception exception) {
            this.LOGGER.error("invoke MService is error:", (Throwable)exception);
        }
        groupFieldsMap.put(groupkey, result);
        serviceMap.put(groupkey, service);
    }
}

