/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageHandler;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageParser;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgParserBizHelper;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.EmailMessageHandler;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.EmailMessageParser;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.MessageContentDO;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.SmsMessageHandler;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.SmsMessageParser;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.WhiteListCheckService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.YzjMessageHandler;
import kd.tsc.tsrbd.common.constants.CfgMsgTemplateConstants;
import kd.tsc.tsrbd.common.entity.msgtrack.MsgTrackDTO;
import kd.tsc.tsrbd.common.enums.CfmMsgChannel;
import org.apache.commons.lang3.ObjectUtils;

public class CfgMessageService {
    private static Log logger = LogFactory.getLog(CfgMessageService.class);
    private static Map<String, MessageChannels> MSG_CHANNEL_MAP = new HashMap<String, MessageChannels>(16);
    private static Map<String, String> LABEL_VARIABLE_MAP = Maps.newHashMap();
    private static Map<MessageChannels, CfgMessageParser> CFG_MSG_PARSER_MAP = new HashMap<MessageChannels, CfgMessageParser>(16);
    private static Map<String, CfgMessageHandler> messageHandlerMap = new HashMap<String, CfgMessageHandler>(16);

    public static List<Long> sendMessage(List<MessageContentDO> messageContentDOList) {
        Date date1 = new Date();
        ArrayList msgIds = Lists.newArrayListWithExpectedSize((int)16);
        for (MessageContentDO messageContentDO : messageContentDOList) {
            if (!WhiteListCheckService.checkMessageDO(messageContentDO)) continue;
            if (null != messageContentDO.getMessageChannel()) {
                if ("sms".equals(messageContentDO.getMessageChannel().getNumber())) {
                    messageContentDO.setChannelType("shortMsg");
                } else {
                    messageContentDO.setChannelType("email");
                }
            }
            Long msgId = messageHandlerMap.get(messageContentDO.getChannelType()).sendMessage(messageContentDO);
            CfgMessageService.generateMsgTrack(msgId, messageContentDO);
            msgIds.add(msgId);
        }
        Date date2 = new Date();
        logger.info("sendMessage date:{}", (Object)(date2.getTime() - date1.getTime()));
        return msgIds;
    }

    public String getContentByChannel(MessageChannels messageChannels) {
        return null;
    }

    public static boolean isSendChannelMsg(IFormView formView, CfmMsgChannel msgChannel) {
        block18: {
            String entityId = formView.getEntityId();
            if (HRStringUtils.equals((String)entityId, (String)CfgMsgTemplateConstants.MSG_TEMPLATE_INTEGRATE)) {
                String channelStrs = (String)formView.getModel().getValue("msgchannellist");
                if (HRStringUtils.isEmpty((String)channelStrs)) {
                    return false;
                }
                try (Stream<String> channelList = Arrays.stream(HRStringUtils.split((String)channelStrs, (String)",")).distinct();){
                    if (channelList.anyMatch(channel -> HRStringUtils.equals((String)channel, (String)String.valueOf(msgChannel.getChannelId())))) {
                        boolean bl = true;
                        return bl;
                    }
                    break block18;
                }
            }
            String pageId = formView.getPageCache().get("cache_msg_tpl_page_id");
            IFormView msgTplPage = SessionManager.getCurrent().getView(pageId);
            if (HRObjectUtils.isEmpty((Object)msgTplPage)) {
                return false;
            }
            return CfgMessageService.isSendChannelMsg(msgTplPage, msgChannel);
        }
        return false;
    }

    public static void resendMsgByMsgLogId(List<Long> msgLogIds) {
        MessageCenterServiceHelper.resendMessageByIds(msgLogIds);
    }

    public static void generateMsgTrack(Long msgId, MessageContentDO messageContentDO) {
        MsgTrackDTO msgTrackDTO = messageContentDO.getMsgTrackDTO();
        if (null != msgTrackDTO) {
            msgTrackDTO.setMsgID(msgId);
            msgTrackDTO.setSendStatus("0");
        }
    }

    public static void sendMessage(Map<String, List<Map<String, Object>>> msgList) {
        for (Map.Entry<String, List<Map<String, Object>>> entry : msgList.entrySet()) {
            String[] msgChannels;
            List<Map<String, Object>> value = entry.getValue();
            String msgTplId = (String)value.get(0).get("id");
            DynamicObject msgTplDy = CfgMsgTemplateHelper.findQuestionnaireById(msgTplId);
            String msgChannelList = msgTplDy.getString("msgchannellist");
            logger.info("the message Channel List:{}", (Object)msgChannelList);
            if (msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
                return;
            }
            ArrayList<MessageContentDO> messageContentDOList = new ArrayList<MessageContentDO>(10);
            for (String msgChannel : msgChannels = msgChannelList.split(",")) {
                if (msgChannel.isEmpty()) continue;
                for (Map<String, Object> receiverParam : value) {
                    if (MessageChannels.SMS == MSG_CHANNEL_MAP.get(msgChannel) && ObjectUtils.isEmpty((Object)receiverParam.get("phone"))) continue;
                    MessageContentDO messageContentDO = CfgMessageService.constructMessageContentDOFromView(MSG_CHANNEL_MAP.get(msgChannel), msgTplDy, receiverParam);
                    messageContentDOList.add(messageContentDO);
                }
            }
            List<Long> object = CfgMessageService.sendMessage(messageContentDOList);
        }
    }

    private static MessageContentDO constructMessageContentDOFromView(MessageChannels messageChannel, DynamicObject msgTplDy, Map<String, Object> customParams) {
        String messageTemplate = "";
        messageTemplate = MessageChannels.EMAIL == messageChannel ? msgTplDy.getString("emailrichtextfd_tag") : msgTplDy.getString("smstemplate");
        Long msgSceneTypeId = Long.valueOf(customParams.get("msgSceneType").toString());
        Long msgReceiverTypeId = Long.valueOf(customParams.get("msgReceiverType").toString());
        LABEL_VARIABLE_MAP = CfgMessageService.constructLabelVariablesMap(msgSceneTypeId, msgReceiverTypeId);
        String phone = (String)customParams.get("phone");
        String email = (String)customParams.get("email");
        String theme = CfgMsgParserBizHelper.parseEmailTheme(msgTplDy.getString("emailtheme"), LABEL_VARIABLE_MAP, customParams);
        if (ObjectUtils.isNotEmpty((Object)customParams.get("ccFlag"))) {
            theme = ResManager.loadKDString((String)"\u6284\u9001-", (String)"MsgTemplateIntegrateEdit_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]) + theme;
        }
        customParams.put("emailtheme", theme);
        customParams.put("replaceVar", "true");
        MessageContentDO messageContentDO = new MessageContentDO();
        messageContentDO.setMessageChannel(messageChannel);
        messageContentDO.setMessageContent(CFG_MSG_PARSER_MAP.get(messageChannel).parseMessage(messageTemplate, customParams, LABEL_VARIABLE_MAP));
        messageContentDO.setReceiverPhone(phone);
        messageContentDO.setReceiverEmail(email);
        messageContentDO.setEmailTitle(theme);
        if (null != customParams.get("boType")) {
            String boType = customParams.get("boType").toString();
            messageContentDO.setBoType(boType);
        }
        return messageContentDO;
    }

    private static Map<String, String> constructLabelVariablesMap(Long msgPushSceneId, Long msgRecvTypeId) {
        DynamicObject[] msgTempVariables = CfgMsgTemplateHelper.getMsgTempVariables(msgPushSceneId, msgRecvTypeId);
        HashMap map = Maps.newHashMapWithExpectedSize((int)msgTempVariables.length);
        for (DynamicObject msgTempVariable : msgTempVariables) {
            map.put(msgTempVariable.getString("fieldname"), msgTempVariable.getString("name"));
        }
        return map;
    }

    public static FormShowParameter getMsgTplParameter(IFormView parentView) {
        IFormView msgTplView = CfgMessageService.getMsgTplView(parentView);
        if (null == msgTplView) {
            throw new IllegalArgumentException("\u672a\u83b7\u53d6\u5230\u6d88\u606f\u6a21\u677f\u5b50\u9875\u9762");
        }
        FormShowParameter formShowParameter = msgTplView.getFormShowParameter();
        return formShowParameter;
    }

    public static IFormView getMsgTplView(IFormView parentView) {
        if (null == parentView) {
            throw new IllegalArgumentException("\u5165\u53c2\u7236\u9875\u9762\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u6d88\u606f\u6a21\u677f\u5b50\u9875\u9762");
        }
        String msgTplPageId = parentView.getPageCache().get("cache_msg_tpl_page_id");
        IFormView view = SessionManager.getCurrent().getView(msgTplPageId);
        return view;
    }

    public static void updateVariable(IFormView msgIntegrateView, Map<String, Object> variableMap) {
        Map customParams = msgIntegrateView.getFormShowParameter().getCustomParams();
        for (Map.Entry<String, Object> entry : variableMap.entrySet()) {
            customParams.put(entry.getKey(), entry.getValue());
        }
        msgIntegrateView.cacheFormShowParameter();
    }

    static {
        MSG_CHANNEL_MAP.put("475773782250774528", MessageChannels.EMAIL);
        MSG_CHANNEL_MAP.put("475773159430184960", MessageChannels.SMS);
        messageHandlerMap.put("email", new EmailMessageHandler());
        messageHandlerMap.put("shortMsg", new SmsMessageHandler());
        messageHandlerMap.put("mobileApp", new YzjMessageHandler());
        CFG_MSG_PARSER_MAP.put(MessageChannels.EMAIL, new EmailMessageParser());
        CFG_MSG_PARSER_MAP.put(MessageChannels.SMS, new SmsMessageParser());
        CFG_MSG_PARSER_MAP.put(MessageChannels.YUNZHIJIA, new SmsMessageParser());
    }
}

