/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.common.constants.MsgTplConstants;

public class CfgMsgFormService {
    private static final Log logger = LogFactory.getLog(CfgMsgFormService.class);
    public static final int FONTSIZE = 14;
    private static final String EMAIL_CHANNEL_STR = "475773782250774528";
    private static final String YZJ_CHANNEL_STR = "475756772099906560";
    private static Map<Long, String> MSG_TEMPLATE_VARIABLE_FLEX_MAP = new HashMap<Long, String>(16);
    private static Map<Long, String> MSG_TEMPLATE_VARIABLE_PREFIX_FLEX_MAP = new HashMap<Long, String>(16);

    private CfgMsgFormService() {
        throw new IllegalStateException("Utility class");
    }

    public static void slidePreviewForm(IFormView iFormView, String formId) {
        IClientViewProxy proxy = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
        HashMap<String, String> map1 = new HashMap<String, String>(16);
        map1.put("formId", formId);
        proxy.addAction("setSlideBillFormId", map1);
        HashMap<String, String> map2 = new HashMap<String, String>(16);
        map2.put("formId", formId);
        proxy.addAction("showSlideBill", map2);
    }

    public static Map<String, String> constructLabelVariablesMap(Long msgPushSceneId, Long msgRecvTypeId) {
        DynamicObject[] msgTempVariables = CfgMsgTemplateHelper.getMsgTempVariables(msgPushSceneId, msgRecvTypeId);
        HashMap map = Maps.newHashMapWithExpectedSize((int)msgTempVariables.length);
        for (DynamicObject msgTempVariable : msgTempVariables) {
            map.put(msgTempVariable.getString("fieldname"), msgTempVariable.getString("name"));
        }
        return map;
    }

    public static void updateMsgTempVariablesLabel(IFormView iFormView, Long msgPushSceneId, Long msgRecvTypeId, String msgChannelList, Long methodId, String sendType) {
        String[] msgChannels;
        if (msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
            return;
        }
        for (String msgChannel : msgChannels = msgChannelList.split(",")) {
            if (HRStringUtils.isEmpty((String)msgChannel)) continue;
            CfgMsgFormService.reloadMsgTempVariablesLabelData(iFormView, msgPushSceneId, msgRecvTypeId, Long.valueOf(msgChannel), methodId, sendType);
        }
    }

    public static void clearMsgTempVariablesLabelData(IFormView iFormView, String flexName) {
        HashMap paramMap = Maps.newHashMap();
        ArrayList<Map<String, String>> labelBOList = new ArrayList<Map<String, String>>(10);
        paramMap.put("items", CfgMsgFormService.createLabelShowPanel(labelBOList).createControl().get("items"));
        iFormView.updateControlMetadata(flexName, (Map)paramMap);
    }

    public static void reloadMsgTempVariablesLabelData(IFormView iFormView, Long msgPushSceneId, Long msgRecvTypeId, Long msgChannelId, String msgChannelCategory, String sendType) {
        HashMap paramMap = Maps.newHashMap();
        List<Map<String, String>> labelBOList = CfgMsgFormService.constructMsgTempVariables(msgChannelCategory, msgPushSceneId, msgRecvTypeId, msgChannelId);
        if ("email".equals(msgChannelCategory) && "2".equals(sendType)) {
            labelBOList.removeIf(map -> map.containsValue("email_offerurl"));
        }
        try {
            String[] intvmethods;
            List collect;
            String intvmethodlist;
            boolean containsProperty = iFormView.getModel().getDataEntity().containsProperty("intvmethodlist");
            if (containsProperty && StringUtils.isNotEmpty((String)(intvmethodlist = (String)iFormView.getModel().getValue("intvmethodlist"))) && (!(collect = Arrays.stream(intvmethods = intvmethodlist.split(",")).filter(intvmethod -> !intvmethod.isEmpty()).collect(Collectors.toList())).contains(String.valueOf(1010L)) || !collect.contains(String.valueOf(1040L)))) {
                if (collect.contains(String.valueOf(1010L))) {
                    labelBOList.removeIf(map -> map.containsValue("email_interviewvediolocation"));
                    labelBOList.removeIf(map -> map.containsValue("sms_interviewvediolocation"));
                } else if (collect.contains(String.valueOf(1040L))) {
                    labelBOList.removeIf(map -> map.containsValue("email_interviewlocation"));
                    labelBOList.removeIf(map -> map.containsValue("sms_interviewlocation"));
                } else if (collect.size() == 1 && collect.contains(String.valueOf(1020L))) {
                    labelBOList.removeIf(map -> map.containsValue("email_interviewvediolocation"));
                    labelBOList.removeIf(map -> map.containsValue("sms_interviewvediolocation"));
                    labelBOList.removeIf(map -> map.containsValue("email_interviewlocation"));
                    labelBOList.removeIf(map -> map.containsValue("sms_interviewlocation"));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010CfgMsgFormService\u3011 reloadMsgTempVariablesLabelData error :", (Throwable)e);
        }
        paramMap.put("items", CfgMsgFormService.createLabelShowPanel(labelBOList).createControl().get("items"));
        if (HRStringUtils.isEmpty((String)msgChannelCategory)) {
            iFormView.updateControlMetadata(MSG_TEMPLATE_VARIABLE_FLEX_MAP.get(msgChannelId), (Map)paramMap);
        } else {
            String flexName = "";
            flexName = "email".equals(msgChannelCategory) ? "emailvariablesap" : "smsvariablesap";
            iFormView.updateControlMetadata(flexName, (Map)paramMap);
        }
    }

    public static void reloadMsgTempVariablesLabelData(IFormView iFormView, Long msgPushSceneId, Long msgRecvTypeId, Long msgChannelId, Long intvMethodId, String sendType) {
        HashMap paramMap = Maps.newHashMap();
        List<Map<String, String>> labelBOList = CfgMsgFormService.constructMsgTempVariables(null, msgPushSceneId, msgRecvTypeId, msgChannelId);
        if (intvMethodId.equals(1010L)) {
            labelBOList.removeIf(map -> map.containsValue("email_interviewvediolocation"));
            labelBOList.removeIf(map -> map.containsValue("sms_interviewvediolocation"));
        } else if (intvMethodId.equals(1040L)) {
            labelBOList.removeIf(map -> map.containsValue("email_interviewlocation"));
            labelBOList.removeIf(map -> map.containsValue("sms_interviewlocation"));
        } else if (intvMethodId.equals(1020L)) {
            labelBOList.removeIf(map -> map.containsValue("email_interviewvediolocation"));
            labelBOList.removeIf(map -> map.containsValue("sms_interviewvediolocation"));
            labelBOList.removeIf(map -> map.containsValue("email_interviewlocation"));
            labelBOList.removeIf(map -> map.containsValue("sms_interviewlocation"));
        }
        if ("2".equals(sendType)) {
            labelBOList.removeIf(map -> map.containsValue("email_offerurl"));
        }
        paramMap.put("items", CfgMsgFormService.createLabelShowPanel(labelBOList).createControl().get("items"));
        iFormView.updateControlMetadata(MSG_TEMPLATE_VARIABLE_FLEX_MAP.get(msgChannelId), (Map)paramMap);
    }

    public static List<Map<String, String>> constructMsgTempVariables(String msgChannelCategory, Long msgPushSceneId, Long msgRecvTypeId, Long msgChannelId) {
        DynamicObject[] msgTempVariables = CfgMsgTemplateHelper.getMsgTempVariables(msgPushSceneId, msgRecvTypeId, msgChannelId);
        if (0 == msgTempVariables.length) {
            msgTempVariables = "email".equals(msgChannelCategory) ? CfgMsgTemplateHelper.getMsgTempVariables(msgPushSceneId, msgRecvTypeId, MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY) : CfgMsgTemplateHelper.getMsgTempVariables(msgPushSceneId, msgRecvTypeId, MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY);
            for (DynamicObject msgTempVariable : msgTempVariables) {
                DynamicObjectCollection msgchannel = msgTempVariable.getDynamicObjectCollection("msgchannel");
                DynamicObject dynamicObject = msgchannel.addNew();
                dynamicObject.set("fbasedataid", (Object)msgChannelId);
            }
            CfgMsgTemplateHelper.save(msgTempVariables);
        }
        String variablePrefix = "";
        variablePrefix = HRStringUtils.isEmpty((String)msgChannelCategory) ? MSG_TEMPLATE_VARIABLE_PREFIX_FLEX_MAP.get(msgChannelId) : msgChannelCategory + "_";
        ArrayList<Map<String, String>> msgTempVariablesList = new ArrayList<Map<String, String>>(8);
        for (DynamicObject msgTempVariable : msgTempVariables) {
            msgTempVariablesList.add(CfgMsgFormService.constructLabelMap(msgTempVariable, variablePrefix));
        }
        return msgTempVariablesList;
    }

    public static Map<String, String> constructLabelMap(DynamicObject dynamicObject, String variablesPrefix) {
        HashMap labelMap = Maps.newHashMap();
        labelMap.put("id", variablesPrefix + dynamicObject.getString("fieldname"));
        labelMap.put("name", dynamicObject.getString("name"));
        return labelMap;
    }

    public static FlexPanelAp createLabelShowPanel(List<Map<String, String>> labelBOList) {
        FlexPanelAp labelShowPanelAp = new FlexPanelAp();
        labelShowPanelAp.setKey("ffffww");
        for (Map<String, String> labelBO : labelBOList) {
            LabelAp label = CfgMsgFormService.createLabel(labelBO.get("name"), labelBO.get("id"));
            labelShowPanelAp.getItems().add(label);
        }
        return labelShowPanelAp;
    }

    public static LabelAp createLabel(String labelName, String labelTagObjId) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("label" + labelTagObjId);
        labelAp.setName(new LocaleString(labelName));
        labelAp.setForeColor("#0E5FD8");
        labelAp.setFontSize(14);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("20px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        labelAp.setClickable(true);
        return labelAp;
    }

    public static boolean validMsgChannelContainsYZJ(IFormView iFormView) {
        String msgChannelStr = iFormView.getModel().getDataEntity().getString("msgchannellist");
        if (HRStringUtils.isEmpty((String)msgChannelStr)) {
            return false;
        }
        return msgChannelStr.contains(YZJ_CHANNEL_STR);
    }

    public static void loadComboItemsInMultiComboEdit(IFormView iFormView, DynamicObject[] dynamicObjects, String multiComboEditKey) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(dynamicObjects.length);
        JSONObject json = new JSONObject();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if ("sysnotice".equalsIgnoreCase(dynamicObject.getString("number"))) continue;
            Long id = dynamicObject.getLong("id");
            String name = dynamicObject.getLocaleString("name").getLocaleValue();
            items.add(new ComboItem(new LocaleString(name), String.valueOf(id)));
            json.put(String.valueOf(id), (Object)name);
        }
        if (!items.isEmpty()) {
            ((MulComboEdit)iFormView.getControl(multiComboEditKey)).setComboItems(items);
        }
        iFormView.getPageCache().put("comboItem", json.toString());
    }

    public static void loadComboItemsInMultiComboEditForReceiver(IFormView iFormView, DynamicObject[] dynamicObjects, String multiComboEditKey) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(dynamicObjects.length);
        JSONObject json = new JSONObject();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if ("sysnotice".equalsIgnoreCase(dynamicObject.getString("number"))) continue;
            long id = dynamicObject.getLong("id");
            if (MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY == id) continue;
            String name = dynamicObject.getLocaleString("name").getLocaleValue();
            items.add(new ComboItem(new LocaleString(name), String.valueOf(id)));
            json.put(String.valueOf(id), (Object)name);
        }
        if (!items.isEmpty()) {
            ((MulComboEdit)iFormView.getControl(multiComboEditKey)).setComboItems(items);
        }
        iFormView.getPageCache().put("comboItem", json.toString());
    }

    public static boolean validMsgChannel(IFormView iFormView) {
        String msgChannelStr = iFormView.getModel().getDataEntity().getString("msgchannellist");
        if (HRStringUtils.isEmpty((String)msgChannelStr)) {
            return true;
        }
        DynamicObject dynamicObject = iFormView.getModel().getDataEntity().getDynamicObject("msgpushscene");
        if ("1080".equals(dynamicObject.getString("id"))) {
            return false;
        }
        return !msgChannelStr.contains(EMAIL_CHANNEL_STR);
    }

    public static boolean validEmailthemeIsEmpty(IFormView iFormView) {
        String emailTheme = iFormView.getModel().getDataEntity().getString("emailtheme");
        return HRStringUtils.isEmpty((String)emailTheme);
    }

    public static List<Long> getChannelListId(String listStr) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (String s : listStr.split(",")) {
            if (!HRStringUtils.isNotEmpty((String)s)) continue;
            list.add(Long.valueOf(s));
        }
        return list;
    }

    static {
        MSG_TEMPLATE_VARIABLE_FLEX_MAP.put(MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY, "flexpanelap131211");
        MSG_TEMPLATE_VARIABLE_FLEX_MAP.put(MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY, "flexpanelap1312111");
        MSG_TEMPLATE_VARIABLE_PREFIX_FLEX_MAP.put(MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY, "email_");
        MSG_TEMPLATE_VARIABLE_PREFIX_FLEX_MAP.put(MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY, "sms_");
    }
}

