/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import kd.bos.dataentity.resource.ResManager;
import kd.tsc.tsrbd.common.enums.CfgMsgHtmlTag;
import org.apache.commons.lang3.ObjectUtils;

public class CfgMsgParserBizHelper {
    private static final String TABLE_FLAG = "tableFlag";
    private static final Map<String, String> RECOMMEND_FILTER_RESUME_MAP = new LinkedHashMap<String, String>(16);
    private static final Map<String, String> CANDIDATE_INFO_LIST_MAP = new LinkedHashMap<String, String>(16);
    private static final Map<String, String> CANDIDATE_LIST_MAP = new LinkedHashMap<String, String>(16);
    private static final Map<String, Map<String, String>> TABLE_CONVERT_MAP = new LinkedHashMap<String, Map<String, String>>(16);

    private CfgMsgParserBizHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static StringBuilder constructRecommendFilterTable(Map<String, Object> bizParam, String tableType, String row) {
        StringBuilder sb = new StringBuilder();
        if ("interviewarrangelist".equals(tableType)) {
            sb.append(bizParam.get("interviewarrangelist"));
        } else {
            sb.append(row.split(TABLE_FLAG)[0]);
            Object filterResumeList = bizParam.get(tableType);
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_BEGIN.getHtml());
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_ROW_BEGIN.getHtml());
            Boolean urlReplaceFlag = (Boolean)bizParam.get("URL_REPLACE_FLAG");
            for (Map.Entry<String, String> entry : TABLE_CONVERT_MAP.get(tableType).entrySet()) {
                String value = entry.getValue();
                String uuid = UUID.randomUUID().toString();
                sb.append(MessageFormat.format(CfgMsgHtmlTag.HTML_BODY_TABLE_COLUMN.getHtml(), uuid, value));
            }
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_ROW_END.getHtml());
            if (filterResumeList != null) {
                JSONArray jsonArray = JSON.parseArray((String)filterResumeList.toString());
                List resumeList = jsonArray.toJavaList(JSONObject.class);
                sb.append((CharSequence)CfgMsgParserBizHelper.constructRecommendFilterRowData(resumeList, urlReplaceFlag, tableType));
            }
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_END.getHtml());
            sb.append(row.split(TABLE_FLAG)[1]);
        }
        return sb;
    }

    public static StringBuilder constructRecommendFilterTableForInterview(Map<String, Object> bizParam, String tableType, String row) {
        StringBuilder sb = new StringBuilder();
        if ("interviewarrangelist".equals(tableType)) {
            sb.append(bizParam.get("interviewarrangelist"));
        } else {
            sb.append(row.split(TABLE_FLAG)[0]);
            Object filterResumeList = bizParam.get(tableType);
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_BEGIN.getHtml());
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_ROW_BEGIN.getHtml());
            Boolean urlReplaceFlag = (Boolean)bizParam.get("URL_REPLACE_FLAG");
            for (Map.Entry<String, String> entry : TABLE_CONVERT_MAP.get(tableType).entrySet()) {
                String value = entry.getValue();
                String uuid = UUID.randomUUID().toString();
                sb.append(MessageFormat.format(CfgMsgHtmlTag.HTML_BODY_TABLE_COLUMN.getHtml(), uuid, value));
            }
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_ROW_END.getHtml());
            if (filterResumeList != null) {
                JSONArray jsonArray = JSON.parseArray((String)filterResumeList.toString());
                List resumeList = jsonArray.toJavaList(JSONObject.class);
                sb.append((CharSequence)CfgMsgParserBizHelper.constructRecommendFilterRowData(resumeList, urlReplaceFlag, tableType));
            }
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_END.getHtml());
            sb.append(row.split(TABLE_FLAG)[1]);
        }
        return sb;
    }

    public static StringBuilder constructRecommendFilterRowData(List<JSONObject> rowData, Boolean urlReplaceFlag, String tableType) {
        StringBuilder sb = new StringBuilder();
        for (JSONObject data : rowData) {
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_ROW_BEGIN.getHtml());
            for (Map.Entry<String, String> entry : TABLE_CONVERT_MAP.get(tableType).entrySet()) {
                String key = entry.getKey();
                String uuid = UUID.randomUUID().toString();
                String customValue = data.getString(key);
                if (customValue != null && customValue.contains(",")) {
                    sb.append(urlReplaceFlag != false ? MessageFormat.format(CfgMsgHtmlTag.HTML_BODY_TABLE_REF_COLUMN.getHtml(), customValue.split(",")[1], customValue.split(",")[0]) : MessageFormat.format(CfgMsgHtmlTag.HTML_BODY_TABLE_REF_PREVIEW.getHtml(), uuid, customValue.split(",")[0]));
                    continue;
                }
                sb.append(MessageFormat.format(CfgMsgHtmlTag.HTML_BODY_TABLE_COLUMN.getHtml(), uuid, Optional.ofNullable(customValue).orElse("null")));
            }
            sb.append(CfgMsgHtmlTag.HTML_BODY_TABLE_ROW_END.getHtml());
        }
        return sb;
    }

    public static String MarkHtmlFilter(String message) {
        if (message == null) {
            return null;
        }
        message = Matcher.quoteReplacement(message);
        String[] split = message.split("\n");
        StringBuilder stringBuilder = new StringBuilder("<xmp style = 'display:contents'>");
        stringBuilder.append(split[0]);
        stringBuilder.append("</xmp>");
        for (int i = 1; i < split.length; ++i) {
            stringBuilder.append("<xmp style = 'margin:0'>");
            stringBuilder.append(split[i]);
            stringBuilder.append("</xmp>");
        }
        return stringBuilder.toString();
    }

    public static String EmailThemeHtmlFilter(String message) {
        if (message == null) {
            return null;
        }
        message = Matcher.quoteReplacement(message);
        return "<xmp style = 'display:contents'>" + message + "</xmp>";
    }

    public static String parseEmailTheme(String theme, Map<String, String> labelVariableMap, Map<String, Object> bizParamMap) {
        if (null == theme) {
            return "";
        }
        for (Map.Entry<String, String> entry : labelVariableMap.entrySet()) {
            String key;
            Object object;
            String value = entry.getValue();
            if (!theme.contains(value) || !ObjectUtils.isNotEmpty((Object)(object = bizParamMap.get(key = entry.getKey())))) continue;
            theme = theme.replaceAll("\\{" + value + "}", object.toString());
        }
        return theme;
    }

    private StringBuilder constructCandidateInfoTable() {
        return new StringBuilder();
    }

    private StringBuilder constructInterviewInfoTable() {
        return new StringBuilder();
    }

    static {
        RECOMMEND_FILTER_RESUME_MAP.put("filter_name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"EmailMessageParser_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        RECOMMEND_FILTER_RESUME_MAP.put("filter_position", ResManager.loadKDString((String)"\u5e94\u8058\u804c\u4f4d", (String)"EmailMessageParser_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        RECOMMEND_FILTER_RESUME_MAP.put("filter_sex", ResManager.loadKDString((String)"\u6027\u522b", (String)"EmailMessageParser_2", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        RECOMMEND_FILTER_RESUME_MAP.put("filter_degree", ResManager.loadKDString((String)"\u6700\u9ad8\u5b66\u5386", (String)"EmailMessageParser_3", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        RECOMMEND_FILTER_RESUME_MAP.put("filter_school", ResManager.loadKDString((String)"\u6700\u9ad8\u5b66\u5386\u6bd5\u4e1a\u9662\u6821", (String)"EmailMessageParser_4", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        RECOMMEND_FILTER_RESUME_MAP.put("filter_major", ResManager.loadKDString((String)"\u6700\u9ad8\u5b66\u5386\u4e13\u4e1a", (String)"EmailMessageParser_5", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        RECOMMEND_FILTER_RESUME_MAP.put("filter_workyear", ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650", (String)"EmailMessageParser_6", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        RECOMMEND_FILTER_RESUME_MAP.put("filter_operation", ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"EmailMessageParser_7", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_INFO_LIST_MAP.put("candidate_indexNo", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EmailMessageParser_8", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_INFO_LIST_MAP.put("candidate_name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"EmailMessageParser_9", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_INFO_LIST_MAP.put("candidate_position", ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d", (String)"EmailMessageParser_10", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_INFO_LIST_MAP.put("candidate_sex", ResManager.loadKDString((String)"\u6027\u522b", (String)"EmailMessageParser_11", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_INFO_LIST_MAP.put("candidate_education", ResManager.loadKDString((String)"\u5b66\u5386", (String)"EmailMessageParser_12", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_INFO_LIST_MAP.put("candidate_workYear", ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650", (String)"EmailMessageParser_13", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_INFO_LIST_MAP.put("candidate_adminOrg", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"EmailMessageParser_14", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_INFO_LIST_MAP.put("candidate_operation", ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"EmailMessageParser_15", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_LIST_MAP.put("candidate_name", ResManager.loadKDString((String)"\u5019\u9009\u4eba\u59d3\u540d", (String)"EmailMessageParser_17", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_LIST_MAP.put("position_num", ResManager.loadKDString((String)"\u5e94\u8058\u804c\u4f4d\u6570", (String)"EmailMessageParser_18", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_LIST_MAP.put("recruit_channel", ResManager.loadKDString((String)"\u62db\u8058\u6e20\u9053", (String)"EmailMessageParser_19", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_LIST_MAP.put("candidate_sex", ResManager.loadKDString((String)"\u6027\u522b", (String)"EmailMessageParser_20", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_LIST_MAP.put("candidate_workYear", ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650", (String)"EmailMessageParser_21", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        CANDIDATE_LIST_MAP.put("candidate_operation", ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"EmailMessageParser_23", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        TABLE_CONVERT_MAP.put("filterrsmlist", RECOMMEND_FILTER_RESUME_MAP);
        TABLE_CONVERT_MAP.put("candidateinfolist", CANDIDATE_INFO_LIST_MAP);
        TABLE_CONVERT_MAP.put("candidatelist", CANDIDATE_LIST_MAP);
    }
}

