/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.constants.CfgMsgTemplateConstants;
import kd.tsc.tsrbd.common.enums.TSRBDPreDataEnum;

public class CfgMsgTemplateHelper {
    private CfgMsgTemplateHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static DynamicObject[] queryAllMsgCategoryScene() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(CfgMsgTemplateConstants.MSG_TEMPLATE_CATEGORY);
        String selectFields = "id, name, number";
        QFilter filter = new QFilter("id", "is not null", (Object)"");
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter, filter2};
        return hrBaseServiceHelper.query(selectFields, filters);
    }

    public static TreeNode getTreeNode(DynamicObject dyc, String type, String parentId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(dyc.getString("id"));
        treeNode.setText(dyc.getString("name"));
        treeNode.setParentid(parentId);
        treeNode.setLeaf(true);
        return treeNode;
    }

    public static DynamicObject[] queryMsgSceneByCategory(Long msgCategoryId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(CfgMsgTemplateConstants.MSG_TEMPLATE_SCENE);
        String selectFields = "id, name, group";
        QFilter filter = new QFilter("group.id", "=", (Object)msgCategoryId);
        QFilter[] filters = new QFilter[]{filter};
        return hrBaseServiceHelper.query(selectFields, filters);
    }

    public static DynamicObject[] queryVariablesNameByField(String fieldName, Long msgScene) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(CfgMsgTemplateConstants.MSG_TEMPLATE_FD);
        String selectFields = "id, name";
        QFilter filter = new QFilter("fieldname", "=", (Object)fieldName);
        QFilter msgSceneFilter = new QFilter("msgpushscene.fbasedataid", "=", (Object)msgScene);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter, msgSceneFilter, enableFilter};
        return hrBaseServiceHelper.query(selectFields, filters);
    }

    public static DynamicObject[] queryMsgChannels(List<Long> ids) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(CfgMsgTemplateConstants.MSG_CHANNEL_ENTITY);
        QFilter qFilter = null;
        qFilter = null == ids ? new QFilter("number", "in", Arrays.asList(MessageChannels.EMAIL.getNumber(), MessageChannels.SMS.getNumber())) : new QFilter("id", "in", ids);
        return hrBaseServiceHelper.query("name,number,category", new QFilter[]{qFilter}, "id desc");
    }

    public static DynamicObject[] queryCfgMsgChannels(List<Long> ids) {
        HRBaseServiceHelper msgChannelHelper = new HRBaseServiceHelper("tsrbd_msg_channel");
        DynamicObject[] channels = msgChannelHelper.query("channel", new QFilter[0], "index asc");
        Object[] channelIds = Arrays.stream(channels).map(channel -> channel.getDynamicObject("channel").getLong("id")).toArray();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(CfgMsgTemplateConstants.MSG_CHANNEL_ENTITY);
        QFilter qFilter2 = new QFilter("id", "in", (Object)channelIds);
        if (null != ids) {
            qFilter2.and(new QFilter("id", "in", ids));
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        return hrBaseServiceHelper.query("name,number,category,entryentity", new QFilter[]{qFilter, qFilter2}, "id desc");
    }

    public static Map<Long, Boolean> batchQueryChannelEnable(List channelIdList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(CfgMsgTemplateConstants.MSG_CHANNEL_ENTITY);
        QFilter qFilter = new QFilter("id", "in", (Object)channelIdList);
        DynamicObject[] channelDys = hrBaseServiceHelper.query("enable", new QFilter[]{qFilter});
        Map<Long, Boolean> channelEnableMap = null;
        if (channelDys != null && channelDys.length > 0) {
            channelEnableMap = Arrays.stream(channelDys).collect(Collectors.toMap(channelDy -> channelDy.getLong("id"), channelDy -> channelDy.getBoolean("enable")));
        }
        return channelEnableMap;
    }

    public static DynamicObject[] queryBaseData(String entityName) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qFilter1 = new QFilter("status", "=", (Object)"C");
        QFilter[] filters = new QFilter[]{qFilter, qFilter1};
        return hrBaseServiceHelper.query(filters);
    }

    public static DynamicObject[] getMsgTempVariables(Long msgPushSceneId, Long msgRecvTypeId, Long msgChannelId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtempfd");
        String selectFields = "id, name, fieldname, msgchannel";
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter msgPushSceneFilter = new QFilter("msgpushscene.fbasedataid", "=", (Object)msgPushSceneId);
        QFilter msgRecvTypeFilter = new QFilter("msgreceiver.fbasedataid", "=", (Object)msgRecvTypeId);
        QFilter msgChannelFilter = new QFilter("msgchannel.fbasedataid", "=", (Object)msgChannelId);
        QFilter[] filters = new QFilter[]{msgPushSceneFilter, msgRecvTypeFilter, msgChannelFilter, enableFilter};
        String orderBys = "index ASC,number ASC";
        return hrBaseServiceHelper.query(selectFields, filters, orderBys);
    }

    public static void save(DynamicObject[] dynamicObjects) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtempfd");
        hrBaseServiceHelper.save(dynamicObjects);
    }

    public static DynamicObject[] getMsgTempVariables(Long msgPushSceneId, Long msgRecvTypeId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtempfd");
        String selectFields = "id, name, fieldname";
        QFilter msgPushSceneFilter = new QFilter("msgpushscene.fbasedataid", "=", (Object)msgPushSceneId);
        QFilter msgRecvTypeFilter = new QFilter("msgreceiver.fbasedataid", "=", (Object)msgRecvTypeId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{msgPushSceneFilter, msgRecvTypeFilter, enableFilter};
        String orderBys = "index ASC";
        return hrBaseServiceHelper.query(selectFields, filters, orderBys);
    }

    public static boolean isMsgTemplateValid(Long msgTemplateId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qFilter1 = new QFilter("status", "=", (Object)"C");
        QFilter qFilter2 = new QFilter("id", "=", (Object)msgTemplateId);
        QFilter[] filters = new QFilter[]{qFilter, qFilter1, qFilter2};
        return hrBaseServiceHelper.query(filters).length > 0;
    }

    public static DynamicObject[] queryLatestMsgTemplate(Long msgPushSceneId, Long msgRecvTypeId, Object recruitmentTypeId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        QFilter msgPushSceneFilter = new QFilter("msgpushscene", "=", (Object)msgPushSceneId);
        QFilter msgRecvTypeFilter = new QFilter("msgreceiver", "=", (Object)msgRecvTypeId);
        QFilter baseFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_cfgmsgtemplate", (Long)RequestContext.get().getOrgId());
        if (baseDataQFilter != null) {
            baseFilter.and(baseDataQFilter);
        }
        if (recruitmentTypeId != null) {
            msgPushSceneFilter.and("recrutype", "=", recruitmentTypeId);
        }
        QFilter[] filters = new QFilter[]{msgPushSceneFilter, msgRecvTypeFilter, baseFilter};
        String orderBys = "createtime DESC";
        return hrBaseServiceHelper.query(filters, orderBys);
    }

    public static String queryMsgTemplateEmail(Long msgTemplateId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        String selectFields = "id, number, emailrichtextfd_tag";
        QFilter qFilter = new QFilter("id", "=", (Object)msgTemplateId);
        DynamicObject[] result = hrBaseServiceHelper.query(selectFields, qFilter.toArray());
        return result.length > 0 ? result[0].getString("emailrichtextfd_tag") : null;
    }

    public static boolean queryMsgTemplateIsSysPreSet(Long msgTemplateId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        DynamicObject dynamicObject = hrBaseServiceHelper.loadSingle((Object)msgTemplateId);
        return dynamicObject.getBoolean("issyspreset");
    }

    public static DynamicObject findQuestionnaireById(Object pk) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        return hrBaseServiceHelper.isExists(pk) ? hrBaseServiceHelper.loadSingle(pk) : null;
    }

    public static DynamicObject[] queryMsgReceiverTypeByMsgScene(long msgSceneId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgrecvtype");
        String selectFields = "id,name";
        QFilter qFilter = new QFilter("pushmsgscene.fbasedataid", "=", (Object)msgSceneId);
        return hrBaseServiceHelper.query(selectFields, qFilter.toArray());
    }

    public static DynamicObject[] queryMsgFieldVariableByScene(String sceneNumber, String typeNumber) {
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("tsrbd_cfgmsgscene");
        DynamicObject scene = sceneHelper.loadDynamicObject(new QFilter("number", "=", (Object)sceneNumber));
        HRBaseServiceHelper typeHelper = new HRBaseServiceHelper("tsrbd_cfgmsgrecvtype");
        DynamicObject type = typeHelper.loadDynamicObject(new QFilter("number", "=", (Object)typeNumber));
        return CfgMsgTemplateHelper.getMsgTempVariables(scene.getLong("id"), type.getLong("id"));
    }

    public static DynamicObject[] queryMsgFieldVariableByScene(String sceneNumber, Long typeId) {
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("tsrbd_cfgmsgscene");
        DynamicObject scene = sceneHelper.loadDynamicObject(new QFilter("number", "=", (Object)sceneNumber));
        HRBaseServiceHelper typeHelper = new HRBaseServiceHelper("tsrbd_cfgmsgrecvtype");
        DynamicObject type = typeHelper.loadDynamicObject(new QFilter("id", "=", (Object)typeId));
        return CfgMsgTemplateHelper.getMsgTempVariables(scene.getLong("id"), type.getLong("id"));
    }

    public static DynamicObject[] queryLatestMsgTemplate(Long msgPushSceneId, Long msgRecvTypeId, Object recruitmentTypeId, Long intvmethodId, Long intvcategoryId, Long recrusceneId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        QFilter msgPushSceneFilter = new QFilter("msgpushscene", "=", (Object)msgPushSceneId);
        QFilter msgRecvTypeFilter = new QFilter("msgreceiver", "=", (Object)msgRecvTypeId);
        QFilter baseFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_cfgmsgtemplate", (Long)RequestContext.get().getOrgId());
        if (baseDataQFilter != null) {
            baseFilter.and(baseDataQFilter);
        }
        if (recruitmentTypeId != null) {
            msgPushSceneFilter.and("recrutype", "=", recruitmentTypeId);
        }
        QFilter intvFilter = new QFilter("intvmethod.fbasedataid_id", "=", (Object)intvmethodId);
        if (intvcategoryId != null) {
            intvFilter.and(new QFilter("intvcategory.fbasedataid_id", "=", (Object)intvcategoryId).or("intvcategory.fbasedataid_id", "=", null));
        }
        if (recrusceneId != null && recrusceneId != 0L) {
            intvFilter.and(new QFilter("recruscene.fbasedataid_id", "=", (Object)recrusceneId).or("recruscene.fbasedataid_id", "=", null));
        }
        QFilter[] filters = new QFilter[]{msgPushSceneFilter, msgRecvTypeFilter, baseFilter, intvFilter};
        String orderBys = "createtime DESC";
        return hrBaseServiceHelper.query(filters, orderBys);
    }

    public static DynamicObject[] queryCfgMsgTemplateByPushSceneAndReceiver(Long msgPushSceneId, Long receiverId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        QFilter[] qFilters = new QFilter("msgpushscene", "=", (Object)msgPushSceneId).and("msgreceiver", "=", (Object)receiverId).and("enable", "=", (Object)"1").toArray();
        return hrBaseServiceHelper.query(String.join((CharSequence)",", "id", "emailtheme", "emailrichtextfd_tag", "smstemplate"), qFilters);
    }

    public static String queryCfgMsgTemplateIdByPushSceneAndReceiver(Long msgPushSceneId, Long receiverId, Long issyspresetTempleteId) {
        DynamicObject[] candidateResult = CfgMsgTemplateHelper.queryCfgMsgTemplateByPushSceneAndReceiver(msgPushSceneId, receiverId);
        if (candidateResult.length == 2) {
            DynamicObject noIssyspresetDynamicObject = Arrays.stream(candidateResult).filter(candidate -> candidate.getLong("id") != issyspresetTempleteId.longValue()).findFirst().get();
            return String.valueOf(noIssyspresetDynamicObject.getLong("id"));
        }
        return String.valueOf(issyspresetTempleteId);
    }

    public static Map<String, String> queryCfgMsgTemplateByPushSceneAndReceiver2IntvMail(Long msgPushSceneId, Long receiverId, Long issyspresetTempleteId) {
        DynamicObject[] candidateResult = CfgMsgTemplateHelper.queryCfgMsgTemplateByPushSceneAndReceiver(msgPushSceneId, receiverId);
        String emailTheme = "";
        String emailRichText = "";
        String smstemplate = "";
        if (candidateResult.length == 2) {
            DynamicObject noIssyspresetDynamicObject = Arrays.stream(candidateResult).filter(candidate -> candidate.getLong("id") != issyspresetTempleteId.longValue()).findFirst().get();
            emailTheme = noIssyspresetDynamicObject.getString("emailtheme");
            emailRichText = noIssyspresetDynamicObject.getString("emailrichtextfd_tag");
            smstemplate = noIssyspresetDynamicObject.getString("smstemplate");
        } else if (candidateResult.length == 1) {
            DynamicObject issyspresetDynamicObject = Arrays.stream(candidateResult).filter(candidate -> candidate.getLong("id") == issyspresetTempleteId.longValue()).findFirst().get();
            emailTheme = issyspresetDynamicObject.getString("emailtheme");
            emailRichText = issyspresetDynamicObject.getString("emailrichtextfd_tag");
            smstemplate = issyspresetDynamicObject.getString("smstemplate");
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("emailtheme", emailTheme);
        result.put("emailrichtext", emailRichText);
        result.put("smstemplate", smstemplate);
        return result;
    }

    public static boolean queryMsgTemplateIsCancelScene(Long msgTemplateId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        DynamicObject dynamicObject = hrBaseServiceHelper.loadSingle((Object)msgTemplateId);
        long sceneId = dynamicObject.getDynamicObject("msgpushscene").getLong("id");
        return sceneId == TSRBDPreDataEnum.SCENE_CANCEL_ID.getId();
    }

    public static String queryStatusById(Long pkId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("status", (Object)pkId);
        if (null == dynamicObject) {
            return "";
        }
        return dynamicObject.getString("status");
    }
}

