/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageParser;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgParserBizHelper;
import kd.tsc.tsrbd.common.enums.CfgMsgHtmlTag;
import org.apache.commons.lang3.ObjectUtils;

public class EmailMessageParser
implements CfgMessageParser {
    private static Log logger = LogFactory.getLog(EmailMessageParser.class);
    private static final Set<String> SET_VARIABLES = Sets.newHashSet((Object[])new String[]{"filterrsmlist", "candidateinfolist", "interviewarrangelist", "candidatelist"});
    private static final Set<String> SET_REF_VARIABLES = Sets.newHashSet((Object[])new String[]{"filterlistref", "loginurl", "offerurl", "resumeurl", "positionurl", "intverviewanswer", "logintsivpurl"});
    private static final List<String> LIST_VARIABLES_NAME = Arrays.asList("\u5f85\u7b5b\u9009\u7b80\u5386\u5217\u8868", "\u5019\u9009\u4eba\u4fe1\u606f\u5217\u8868", "\u9762\u8bd5\u5b89\u6392\u8868", "\u5df2\u9009\u5019\u9009\u4eba\u5217\u8868");
    private static final Map<String, String> LIST_VARIABLE_MAP = new LinkedHashMap<String, String>(16);
    private static final String TABLE_FLAG = "tableFlag";

    @Override
    public String parseMessage(String messageContent, Map<String, Object> bizParam, Map<String, String> labelVariableMap) {
        boolean bl;
        if (bizParam.containsKey("filtermark")) {
            bizParam.put("filtermark", CfgMsgParserBizHelper.MarkHtmlFilter((String)bizParam.get("filtermark")));
        }
        if (bizParam.containsKey("sharemark")) {
            bizParam.put("sharemark", CfgMsgParserBizHelper.MarkHtmlFilter((String)bizParam.get("sharemark")));
        }
        StringBuilder emailContent = new StringBuilder();
        Object title = bizParam.get("emailtheme");
        bizParam.put("emailtheme", CfgMsgParserBizHelper.EmailThemeHtmlFilter((String)bizParam.get("emailtheme")));
        String parseRichTextContent = messageContent;
        if (HRStringUtils.isEmpty((String)parseRichTextContent)) {
            return null;
        }
        Boolean urlReplaceFlag = (Boolean)bizParam.get("URL_REPLACE_FLAG");
        String tableType = null;
        if (bizParam.get("replaceVar") != null) {
            for (Map.Entry entry : labelVariableMap.entrySet()) {
                String key = ((String)entry.getKey()).trim();
                String value = ((String)entry.getValue()).trim();
                Object object = bizParam.get(key);
                if (SET_REF_VARIABLES.contains(key) && object != null) {
                    parseRichTextContent = urlReplaceFlag != false ? parseRichTextContent.replaceAll("\\{" + value + "}", MessageFormat.format(CfgMsgHtmlTag.HTML_BODY_LINE_REF_ITEM.getHtml(), object.toString(), bizParam.containsKey(key + "name") ? bizParam.get(key + "name").toString() : object.toString())) : parseRichTextContent.replaceAll("\\{" + value + "}", MessageFormat.format(CfgMsgHtmlTag.HTML_BODY_LINE_REF_ITEM_PREVIEW.getHtml(), bizParam.containsKey(key + "name") ? bizParam.get(key + "name").toString() : object.toString()));
                    continue;
                }
                if (!SET_VARIABLES.contains(key) && object != null) {
                    if (!ObjectUtils.isNotEmpty((Object)object)) continue;
                    parseRichTextContent = parseRichTextContent.replaceAll("\\{" + value + "}", Matcher.quoteReplacement(object.toString()));
                    continue;
                }
                if (!SET_VARIABLES.contains(key)) continue;
                parseRichTextContent = parseRichTextContent.replaceAll("\\{" + value + "}", TABLE_FLAG);
                tableType = key;
            }
        } else {
            for (String string : LIST_VARIABLES_NAME) {
                if (parseRichTextContent.contains(string)) {
                    tableType = LIST_VARIABLE_MAP.get(string);
                }
                if ("interviewarrangelist".equals(tableType)) continue;
                parseRichTextContent = parseRichTextContent.replaceAll("\\{" + string + "}", TABLE_FLAG);
            }
        }
        List<String> rowString = this.parseRichTextToRowData(parseRichTextContent);
        boolean bl2 = bizParam.get("interviewertemplate") != null && (bizParam.get("interviewertemplate") instanceof Boolean ? (Boolean)bizParam.get("interviewertemplate") != false : Boolean.parseBoolean(bizParam.get("interviewertemplate").toString())) ? true : (bl = false);
        if (bl) {
            boolean ccFlag;
            StringBuilder interviewContent = new StringBuilder();
            String htmlStart = CfgMsgHtmlTag.INTERVIEWER_HTML_START.getHtml();
            interviewContent.append(htmlStart);
            String htmlBodyStart = CfgMsgHtmlTag.INTERVIEWER_HTML_BODY_START.getHtml();
            interviewContent.append(htmlBodyStart);
            Object interviewerTitle = bizParam.get("interviewertitle");
            interviewContent.append(interviewerTitle);
            Object bashedLine = bizParam.get("interviewdashedline");
            interviewContent.append(bashedLine);
            StringBuilder other = new StringBuilder();
            other.append("<div style=\"margin-left: 20px;font-size: 14px;margin-right: 20px;margin-top:15px;\">");
            boolean afterTable = false;
            for (String row : rowString) {
                if (row.contains(TABLE_FLAG)) {
                    other.append((CharSequence)CfgMsgParserBizHelper.constructRecommendFilterTable(bizParam, tableType, row));
                    afterTable = true;
                    continue;
                }
                if (afterTable) {
                    other.append("<div style=\" padding-bottom: 10px;\">");
                }
                afterTable = false;
                other.append(row);
            }
            other.append("</div>");
            interviewContent.append((CharSequence)other);
            interviewContent.append("</div></div></div>");
            interviewContent.append(CfgMsgHtmlTag.INTERVIEWER_HTML_END.getHtml());
            boolean bl3 = bizParam.get("ccFlag") != null && (bizParam.get("ccFlag") instanceof Boolean ? (Boolean)bizParam.get("ccFlag") != false : Boolean.parseBoolean(bizParam.get("ccFlag").toString())) ? true : (ccFlag = false);
            if (ccFlag) {
                emailContent.append(interviewContent.toString().replace("href=", ""));
            } else {
                emailContent.append((CharSequence)interviewContent);
            }
        } else {
            emailContent.append(CfgMsgHtmlTag.HTML_HEAD_START.getHtml());
            emailContent.append(MessageFormat.format(CfgMsgHtmlTag.HTML_HEAD_BODY_BEGIN.getHtml(), bizParam.get("emailtheme").toString()));
            emailContent.append("<div style=\"padding:17px 24px\">");
            for (String row : rowString) {
                if (row.contains(TABLE_FLAG)) {
                    emailContent.append((CharSequence)CfgMsgParserBizHelper.constructRecommendFilterTable(bizParam, tableType, row));
                    continue;
                }
                emailContent.append(MessageFormat.format(CfgMsgHtmlTag.HTML_HEAD_BODY_LINE.getHtml(), UUID.randomUUID().toString(), row));
            }
            emailContent.append("</div>");
            emailContent.append(CfgMsgHtmlTag.HTML_END.getHtml());
        }
        return emailContent.toString();
    }

    private List<String> parseRichTextToRowData(String richTextContent) {
        ArrayList<String> rowString = new ArrayList<String>(10);
        String regex = "<p[\\w\\W]*?>[\\w\\W]*?<\\/p>";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(richTextContent);
        while (matcher.find()) {
            rowString.add(matcher.group(0));
        }
        if (rowString.size() <= 1) {
            if (ObjectUtils.isNotEmpty(rowString)) {
                rowString.remove(0);
            }
            String regex1 = "<p>[\\s\\S]*</p>";
            Pattern pattern1 = Pattern.compile(regex1);
            Matcher matcher1 = pattern1.matcher(richTextContent);
            while (matcher1.find()) {
                rowString.add(matcher1.group());
            }
        }
        return rowString;
    }

    static {
        LIST_VARIABLE_MAP.put("\u5f85\u7b5b\u9009\u7b80\u5386\u5217\u8868", "filterrsmlist");
        LIST_VARIABLE_MAP.put("\u5019\u9009\u4eba\u4fe1\u606f\u5217\u8868", "candidateinfolist");
        LIST_VARIABLE_MAP.put("\u9762\u8bd5\u5b89\u6392\u8868", "interviewarrangelist");
        LIST_VARIABLE_MAP.put("\u5df2\u9009\u5019\u9009\u4eba\u5217\u8868", "candidatelist");
    }
}

