/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class EmailServiceCustomer
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(EmailServiceCustomer.class);
    public static final String TYPE = "outemail";

    public String getServiceType() {
        return TYPE;
    }

    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            logger.info("sendMessage#MessageInfo\uff1a{}", (Object)message);
            MessageUtils.wrapMessageContent((MessageInfo)message, (String)"email");
            Map params = message.getParams();
            List openIds = (List)params.get("email");
            ArrayList<MessageUser> messageUsers = new ArrayList<MessageUser>(openIds.size());
            for (String openId : openIds) {
                messageUsers.add(new MessageUser(Long.valueOf(0L), openId, (String)null, (String)null));
            }
            if (messageUsers.isEmpty()) {
                logger.info(String.format("content: %s, userIds not have openIds, and stop send message", message.getContent()));
                throw new WFMessageServiceException((Throwable)null, WFErrorCode.smsSendMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage((List)messages)) {
                logger.info("EmailServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException((Throwable)null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, !message.isSignleEmail());
        }
        catch (Exception var5) {
            throw new WFMessageServiceException((Throwable)var5, WFErrorCode.emailSendMsgError(), new Object[]{var5.getMessage()});
        }
    }

    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        logger.info("inspectChannelInfo#MsgChannelInfo\uff1a{}", (Object)msgChannelInfo);
        String smtpHost = msgChannelInfo.getSmtphost();
        String smtpPort = msgChannelInfo.getSmtpport();
        String mobileAppConfig = msgChannelInfo.getMobileappconfig();
        if (!(WfUtils.isEmpty((String)smtpHost) || WfUtils.isEmpty((String)smtpPort) || WfUtils.isEmpty((String)mobileAppConfig))) {
            JSONObject configs = JSON.parseObject((String)mobileAppConfig);
            String auth = configs.getString("auth");
            if (Boolean.parseBoolean(auth)) {
                String username = msgChannelInfo.getUsername();
                String password = msgChannelInfo.getPassword();
                if (WfUtils.isEmpty((String)username) || WfUtils.isEmpty((String)password)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        EmailInfo emailInfo = this.buildEmailInfo(messageInfo, messageUsers);
        logger.info(String.format("\u90ae\u4ef6\u670d\u52a1\uff1a\u521b\u5efa\u6d88\u606f,message:%s", messageInfo));
        logger.info("\u90ae\u4ef6\u670d\u52a1\u9644\u4ef6: {} ", (Object)messageInfo.getAttachment());
        return EmailServiceCustomer.sendEmail(emailInfo);
    }

    public static Map<String, Object> sendEmail(EmailInfo emailInfo) {
        logger.info("sendEmail--postemail, title:" + emailInfo.getTitle() + " content:" + emailInfo.getContent() + " attachments:" + emailInfo.getAttachments() + " attachmentNames:" + emailInfo.getAttachmentNames());
        final MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)TYPE);
        if (msgChannelInfo == null) {
            return kd.bos.message.service.utils.MessageUtils.wrapResult((String)ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6d88\u606f\u670d\u52a1\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6\uff0c\u672a\u914d\u7f6e\u6d88\u606f\u670d\u52a1\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1", (String)"EmailHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", msgChannelInfo.getSmtphost());
        props.put("mail.smtp.port", msgChannelInfo.getSmtpport());
        props.put("mail.smtp.connectiontimeout", "30000");
        props.put("mail.smtp.timeout", "30000");
        String domain = msgChannelInfo.getDomain();
        if (domain != null && StringUtils.isNotBlank((CharSequence)domain)) {
            props.put("mail.smtp.connectiontimeout", "40000");
            props.put("mail.smtp.timeout", "40000");
            props.setProperty("mail.smtp.auth.ntlm.domain", domain);
            logger.info("sendEmail--email domain is setted");
        } else {
            props.put("mail.smtp.connectiontimeout", "30000");
            props.put("mail.smtp.timeout", "30000");
            props.remove("mail.smtp.auth.ntlm.domain");
        }
        final boolean auth = EmailServiceCustomer.setAuthAndProtocol(msgChannelInfo.getMobileappconfig(), props);
        logger.info(String.format("EmailHandlerTest- mail.smtp.starttls.enable value is %s", props.getProperty("mail.smtp.starttls.enable")));
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.socketFactory.port", msgChannelInfo.getSmtpport());
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("mail.mime.splitlongparameters", "false");
        System.setProperty("mail.mime.charset", "UTF-8");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                String userName = "";
                String pw = "";
                if (auth) {
                    pw = msgChannelInfo.getPassword();
                    userName = msgChannelInfo.getUsername();
                }
                String pwAfterDcode = "";
                if (StringUtils.isNotBlank((CharSequence)pw)) {
                    pwAfterDcode = pw.startsWith("d@f*g:") ? Encrypters.decode((String)pw) : pw;
                }
                return new PasswordAuthentication(userName, pwAfterDcode);
            }
        });
        session.setDebug(false);
        EmailServiceCustomer.wrapProps(msgChannelInfo.getConfig(), props, session);
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(msgChannelInfo.getFromaccount(), msgChannelInfo.getFromusername()));
            InternetAddress[] receiverAddress = null;
            if (emailInfo.getReceiver() != null && !emailInfo.getReceiver().isEmpty()) {
                receiverAddress = EmailServiceCustomer.getInternetAddress(emailInfo.getReceiver());
            }
            if (receiverAddress != null && receiverAddress.length != 0) {
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])receiverAddress);
                if (emailInfo.getCopyReceiver() != null && !emailInfo.getCopyReceiver().isEmpty()) {
                    mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])EmailServiceCustomer.getInternetAddress(emailInfo.getCopyReceiver()));
                }
                if (emailInfo.getSecretReceiver() != null && !emailInfo.getSecretReceiver().isEmpty()) {
                    mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])EmailServiceCustomer.getInternetAddress(emailInfo.getSecretReceiver()));
                }
                mimeMessage.setSubject(emailInfo.getTitle());
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart contentMimeBody = new MimeBodyPart();
                String contentType = "TEXT".equalsIgnoreCase(emailInfo.getContentMimeType()) ? "text/plain;charset=UTF-8" : "text/html;charset=UTF-8";
                contentMimeBody.setContent((Object)emailInfo.getContent(), contentType);
                multipart.addBodyPart((BodyPart)contentMimeBody);
                if (EmailServiceCustomer.isAttachment(emailInfo)) {
                    EmailServiceCustomer.wrapEmailAttachments(emailInfo, (Multipart)multipart);
                }
                mimeMessage.setContent((Multipart)multipart);
                mimeMessage.setSentDate(new Date());
                logger.info("sendEmail--email everything is ready, go and email content:" + emailInfo.getContent());
                logger.info("sendEmail--Content:" + mimeMessage.getContent());
                Transport.send((Message)mimeMessage);
                return kd.bos.message.service.utils.MessageUtils.wrapResult((String)"success");
            }
            logger.info("sendEmail--email receiver is null and stop send email");
            return kd.bos.message.service.utils.MessageUtils.wrapResult((String)"email receiver is null and stop send email");
        }
        catch (Exception var11) {
            logger.error(kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)var11));
            return kd.bos.message.service.utils.MessageUtils.wrapResult((String)var11.getMessage());
        }
    }

    private static boolean setAuthAndProtocol(String mobileAppConfig, Properties props) {
        String smtpProtocol;
        boolean auth = true;
        if (StringUtils.isBlank((CharSequence)mobileAppConfig)) {
            return auth;
        }
        JSONObject jsonConfig = JSONObject.parseObject((String)mobileAppConfig);
        if (jsonConfig == null) {
            return auth;
        }
        if (StringUtils.isNotBlank((Object)jsonConfig.getBoolean("auth"))) {
            auth = jsonConfig.getBoolean("auth");
            props.put("mail.smtp.auth", String.valueOf(auth));
        }
        if ("ssl".equalsIgnoreCase(smtpProtocol = jsonConfig.getString("smtpProtocol"))) {
            props.put("mail.smtp.ssl.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        } else if ("tls".equalsIgnoreCase(smtpProtocol)) {
            props.put("mail.smtp.starttls.enable", "true");
        } else if ("all".equalsIgnoreCase(smtpProtocol)) {
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.ssl.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        } else {
            props.remove("mail.smtp.ssl.enable");
            props.remove("mail.smtp.socketFactory.class");
            props.remove("mail.smtp.starttls.enable");
        }
        return auth;
    }

    private static void wrapProps(String config, Properties props, Session session) {
        try {
            JSONArray deleteProps;
            if (StringUtils.isBlank((CharSequence)config)) {
                return;
            }
            JSONObject jsonConfig = JSONObject.parseObject((String)config);
            if (jsonConfig == null) {
                return;
            }
            JSONObject jsonProps = jsonConfig.getJSONObject("mailSmtpProps");
            if (jsonProps == null) {
                return;
            }
            JSONObject addProps = jsonProps.getJSONObject("addProps");
            if (addProps != null) {
                for (Map.Entry entry : addProps.entrySet()) {
                    if ("session.debug".equalsIgnoreCase((String)entry.getKey())) {
                        session.setDebug(((Boolean)entry.getValue()).booleanValue());
                        continue;
                    }
                    props.setProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            if ((deleteProps = jsonProps.getJSONArray("deleteProps")) != null) {
                for (int i = 0; i < deleteProps.size(); ++i) {
                    props.remove(deleteProps.get(i));
                }
            }
        }
        catch (Exception var8) {
            logger.info("wrapProps is error");
        }
    }

    private static void wrapEmailAttachments(EmailInfo emailInfo, Multipart multipart) throws UnsupportedEncodingException, MessagingException {
        List attachments = emailInfo.getAttachments();
        List attachmentNames = emailInfo.getAttachmentNames();
        logger.info("wrapEmailAttachments--email, attachments:" + attachments + " attachmentNames:" + attachmentNames);
        if (kd.bos.message.utils.MessageUtils.isAttachmentBeyondLimit((List)attachments)) {
            logger.info("sendEmail--attachment size beyond limit");
        } else {
            for (int i = 0; i < attachments.size(); ++i) {
                byte[] bt = (byte[])attachments.get(i);
                if (bt == null || bt.length == 0) continue;
                logger.info("forattachments", (Object)i);
                MimeBodyPart attachmentBody = new MimeBodyPart();
                DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(bt, "application/octet-stream"));
                attachmentBody.setDataHandler(dataHandler);
                attachmentBody.setFileName(MimeUtility.encodeText((String)((String)attachmentNames.get(i))));
                multipart.addBodyPart((BodyPart)attachmentBody);
            }
        }
    }

    private static boolean isAttachment(EmailInfo emailInfo) {
        boolean isAttachment = false;
        List attachments = emailInfo.getAttachments();
        List attachmentNames = emailInfo.getAttachmentNames();
        if (attachmentNames != null && !attachmentNames.isEmpty() && attachments != null && !attachments.isEmpty() && attachmentNames.size() == attachments.size()) {
            isAttachment = true;
        }
        logger.info("isAttachment\uff1a{}", (Object)isAttachment);
        return isAttachment;
    }

    private static InternetAddress[] getInternetAddress(List<String> userAddress) throws AddressException {
        LinkedHashSet<String> addresses = new LinkedHashSet<String>();
        for (String ua : userAddress) {
            if (!StringUtils.isNotBlank((CharSequence)ua)) continue;
            addresses.add(ua);
        }
        InternetAddress[] ia = null;
        if (!addresses.isEmpty()) {
            int i = 0;
            ia = new InternetAddress[addresses.size()];
            for (String address : addresses) {
                ia[i++] = new InternetAddress(address);
            }
        }
        return ia;
    }

    private static List<byte[]> getEmailAttachementByte(List<String> attachmentWebUrls) {
        ArrayList<byte[]> attachments = new ArrayList<byte[]>();
        try {
            for (String path : attachmentWebUrls) {
                attachments.add(EmailServiceCustomer.getDataByte(path));
            }
        }
        catch (Exception var4) {
            logger.info("sendEmail--get attachment byte data error by attachmentWebUrls");
        }
        return attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getDataByte(String path) throws IOException {
        URL url = new URL(path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.connect();
        conn.setReadTimeout(5000);
        conn.setConnectTimeout(5000);
        byte[] bt = null;
        try (InputStream is = conn.getInputStream();){
            bt = EmailServiceCustomer.input2byte(is);
        }
        return bt;
    }

    private static byte[] input2byte(InputStream inStream) throws IOException {
        int rc;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        boolean var3 = false;
        while ((rc = inStream.read(buff, 0, 1024)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    private EmailInfo buildEmailInfo(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        Map param;
        ArrayList<String> address = new ArrayList<String>();
        for (MessageUser messageUser : messageUsers) {
            String openId = messageUser.getOpenId();
            if (!WfUtils.isNotEmpty((String)openId)) continue;
            address.add(openId);
        }
        EmailInfo emailInfo = new EmailInfo();
        emailInfo.setContentMimeType("HTML");
        emailInfo.setReceiver(address);
        emailInfo.setTitle("\u6d4b\u8bd5" + messageInfo.getTitle());
        emailInfo.setContent(messageInfo.getContent());
        emailInfo.setSignleEmail(messageInfo.isSignleEmail());
        MessageAttachment attachment = messageInfo.getAttachment();
        if (attachment != null) {
            emailInfo.setAttachments(attachment.getAttachments());
            emailInfo.setAttachmentNames(attachment.getAttachmentNames());
        }
        if ((param = messageInfo.getParams()) != null && !param.isEmpty()) {
            Object secretReceivers;
            Object copyRecevers = param.get("emailCR");
            if (StringUtils.isNotBlank(copyRecevers)) {
                emailInfo.setCopyReceiver((List)copyRecevers);
            }
            if (StringUtils.isNotBlank(secretReceivers = param.get("emailSR"))) {
                emailInfo.setSecretReceiver((List)secretReceivers);
            }
        }
        return emailInfo;
    }
}

