/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.IMsgEventListener;
import kd.tsc.tsrbd.business.domain.msgtrack.service.MsgTrackHelper;
import kd.tsc.tsrbd.business.domain.sharerecord.service.ShareRecordSendService;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class MsgTplEventListener
implements IMsgEventListener {
    private static Log logger = LogFactory.getLog(MsgTplEventListener.class);
    private static final String CHANNEL_MSG_ID = "channelMsgId";
    private static final String STATE = "state";
    private static final String ERROR_INFO = "errorinfo";
    private static final String RETRIES = "retries";

    public void subSuccessMsgInfo(Long msgId, Map<String, Object> data) {
        logger.info("MsgTplEventListener.subSuccessMsgInfo:data[{}]", data);
        if (null == MsgTrackHelper.queryMsgTrackByMsg(msgId)) {
            Date sendDate = DateUtils.nowDateTime();
            Date endDate = DateUtils.afterNowDateTime((int)7);
            ShareRecordSendService.getInstance().changeSendStatus(msgId, sendDate, endDate);
        } else {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
            paramMap.put("msgid", msgId);
            paramMap.put("sendstatus", "1");
            paramMap.put("faireason", " ");
            MsgTrackHelper.updateMsgTrackByResult(paramMap);
        }
    }

    public void subFailMsgInfo(Long msgId, Map<String, Object> data) {
        logger.info("MsgTplEventListener.subFailMsgInfo:data[{}]", data);
        this.updateResult(msgId, data);
    }

    private void updateResult(Long msgId, Map<String, Object> data) {
        Long channelMsgId = (Long)data.get(CHANNEL_MSG_ID);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)4);
        paramMap.put("msgid", msgId);
        paramMap.put("sendstatus", "2");
        paramMap.put("faireason", ResManager.loadKDString((String)"\u5176\u4ed6\u539f\u56e0", (String)"MsgTrack_6", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        paramMap.put("msglogid", channelMsgId);
        MsgTrackHelper.updateMsgTrackByResult(paramMap);
    }
}

