/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.param.AppParam;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.application.external.org.BizOrgUnitService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.MessageContentDO;

public class WhiteListCheckService {
    private static final String EMAIL_TYPE = "1";
    private static final String SMS_TYPE = "0";
    private static final String YZJ_TYPE = "2";
    private static Map<MessageChannels, String> MSG_CHANNEL_PARAM_MAP = new HashMap<MessageChannels, String>(16);

    private WhiteListCheckService() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean checkMessageDO(MessageContentDO messageContentDO) {
        AppParam appParam = new AppParam();
        appParam.setOrgId(BizOrgUnitService.getView24RootOrgId());
        appParam.setAppId("1NQE0WQWLLZ=");
        Boolean checkFlag = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)MSG_CHANNEL_PARAM_MAP.get(messageContentDO.getMessageChannel()));
        if (null == checkFlag || !checkFlag.booleanValue()) {
            return true;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgwhitelist");
        String selectFields = "id, name, number";
        QFilter filter = new QFilter("id", "is not null", (Object)"");
        if (null != messageContentDO.getMessageChannel()) {
            if ("sms".equals(messageContentDO.getMessageChannel().getNumber())) {
                messageContentDO.setChannelType("shortMsg");
            } else {
                messageContentDO.setChannelType("email");
            }
        }
        switch (messageContentDO.getChannelType()) {
            case "email": {
                filter.and(new QFilter("type", "=", (Object)EMAIL_TYPE));
                filter.and(new QFilter("value", "=", (Object)messageContentDO.getReceiverEmail()));
                break;
            }
            case "shortMsg": {
                filter.and(new QFilter("type", "=", (Object)SMS_TYPE));
                filter.and(new QFilter("value", "=", (Object)messageContentDO.getReceiverPhone().replace("+86-", "")));
                break;
            }
        }
        DynamicObject[] res = hrBaseServiceHelper.query(selectFields, filter.toArray());
        return res.length > 0;
    }

    static {
        MSG_CHANNEL_PARAM_MAP.put(MessageChannels.EMAIL, "emailcheck");
        MSG_CHANNEL_PARAM_MAP.put(MessageChannels.SMS, "smscheck");
        MSG_CHANNEL_PARAM_MAP.put(MessageChannels.YUNZHIJIA, "yunzhijiacheck");
    }
}

