/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.cfgresurule.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class CfgResumeRuleHelper {
    private static final Log logger = LogFactory.getLog(CfgResumeRuleHelper.class);

    private CfgResumeRuleHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Tuple<ArrayList<String>, HashMap<String, ILocaleString>> generateFilterFieldKeys() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_cfgresurulefd");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        ArrayList<String> resultList = new ArrayList<String>(dynamicObjects.length);
        HashMap fieldNameLangMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long fieldId = dynamicObject.getLong("rulefield.id");
            String entityName = dynamicObject.getString("entryname");
            String result = !"tstpm_rsm".equals(entityName) ? entityName + '.' + dynamicObject.getString("rulefield.fieldkey").trim() : dynamicObject.getString("rulefield.fieldkey").trim();
            if ("10060_S".equals(CfgResumeRuleHelper.getMtdFieldCtrTypeByFieldId(fieldId))) {
                result = result + '.' + "name";
            }
            resultList.add(result);
            fieldNameLangMap.put(result, dynamicObject.getLocaleString("rulefield.name"));
        }
        return new Tuple(resultList, (Object)fieldNameLangMap);
    }

    public static String getMtdFieldCtrTypeByFieldId(long fieldId) {
        HRBaseServiceHelper fieldServiceHelper = new HRBaseServiceHelper("tsrbd_mtdfield");
        DynamicObject fieldObj = fieldServiceHelper.queryOne("mtdfieldctrtyp", (Object)fieldId);
        return fieldObj.getDynamicObject("mtdfieldctrtyp").getString("number");
    }

    public static QFilter getQFilterFromFilterCondition(String entityName, FilterCondition filterCondition) {
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        return PermCommonUtil.getQFilterFromFilterCondition((MainEntityType)entityType, (FilterCondition)filterCondition);
    }

    public static boolean isCandidateEliminated(long rsmId, long positionId) {
        logger.info("{} with {} enter CfgResumeRuleHelper", (Object)rsmId, (Object)positionId);
        HRBaseServiceHelper positionServiceHelper = new HRBaseServiceHelper("tspr_position");
        DynamicObject positionObj = positionServiceHelper.queryOne("manageinfo.cfgresurule", (Object)positionId);
        DynamicObject resumeRuleObj = positionObj.getDynamicObject("manageinfo.cfgresurule");
        if (resumeRuleObj == null) {
            logger.info("not exist rule");
            return false;
        }
        long cfgResumeRuleId = resumeRuleObj.getLong("id");
        HRBaseServiceHelper cfgResumeServiceHelper = new HRBaseServiceHelper("tsrbd_cfgresurule");
        DynamicObject cfgResumeRuleObj = cfgResumeServiceHelper.queryOne("filtervalue_tag", (Object)cfgResumeRuleId);
        String filterValue = cfgResumeRuleObj.getString("filtervalue_tag");
        logger.info("filtervalue is :{}", (Object)filterValue);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterValue, FilterCondition.class);
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"tsrbd_resumelist");
        QFilter qFilter = PermCommonUtil.getQFilterFromFilterCondition((MainEntityType)entityType, (FilterCondition)filterCondition);
        logger.info("qFilter is :{}", (Object)qFilter.toString());
        HRBaseServiceHelper rsmServiceHelper = new HRBaseServiceHelper("tsrbd_resumelist");
        QFilter pkFilter = new QFilter("id", "=", (Object)rsmId);
        DynamicObject[] query = rsmServiceHelper.query(new QFilter[]{qFilter.and(pkFilter)});
        logger.info("result is :{}", (Object)query.length);
        return query.length == 0;
    }
}

