/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.channel.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class ChannelService {
    private static final HRBaseServiceHelper CHANNEL_SERVICE_HELPER = new HRBaseServiceHelper("tsrbd_channelaccount");

    public static List<Long> checkOpChannelAccount(List<Long> idList) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", idList)};
        DynamicObject[] result = CHANNEL_SERVICE_HELPER.loadDynamicObjectArray(filters);
        Long userId = TSCRequestContext.getUserId();
        ArrayList failResult = Lists.newArrayListWithExpectedSize((int)idList.size());
        for (DynamicObject dynamicObject : result) {
            long create = dynamicObject.getDynamicObject("creator").getLong("id");
            if (create == userId) continue;
            failResult.add(dynamicObject.getLong("id"));
        }
        return failResult;
    }

    public static String getEditFailChannelPermissionError() {
        return ResManager.loadKDString((String)"\u65e0\u201c\u6e20\u9053\u8d26\u53f7\u201d\u7684\u201c\u4fee\u6539\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChannelAccountList_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
    }

    public static String getDeleteChannelPermissionError() {
        return ResManager.loadKDString((String)"\u4ec5\u80fd\u5220\u9664\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e", (String)"ChannelAccountList_2", (String)"tsc-tsrbd-opplugin", (Object[])new Object[0]);
    }
}

