/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.channel.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class RecruchnPermHelper {
    private static final Map<String, String> PERM_MAP = new HashMap<String, String>(16);
    public static final String QUERY_PERM = "47150e89000000ac";
    public static final String MODIFY_PERM = "4715a0df000000ac";

    public static RecruchnPermHelper getInstance() {
        return RecruchnPermHelperHolder.ADVERT_PERM_HELPER;
    }

    private RecruchnPermHelper() {
    }

    public boolean verifyHasPerm(String entityId, String operateCode, long useOrgId) {
        String permCode = PERM_MAP.get(operateCode);
        if (HRStringUtils.isEmpty((String)permCode)) {
            return true;
        }
        String appId = AppMetadataCache.getAppInfo((String)"tsrbd").getId();
        int perm = PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (Long)useOrgId, (String)appId, (String)entityId, (String)permCode);
        return perm == 1;
    }

    public boolean verifyChannelContactPerm(String operateCode) {
        return this.verifyHasPerm("tsrbd_channelcontact", operateCode, TSCRequestContext.getOrgId());
    }

    public boolean verifyChannelAccountPerm(String operateCode) {
        return this.verifyHasPerm("tsrbd_channelaccount", operateCode, TSCRequestContext.getOrgId());
    }

    public boolean verifyChannelContractPerm(String operateCode) {
        return this.verifyHasPerm("tsrbd_channelcontract", operateCode, TSCRequestContext.getOrgId());
    }

    public boolean verifyChannelPerm(String operateCode) {
        return this.verifyHasPerm("tsrbd_recruchnlnm", operateCode, TSCRequestContext.getOrgId());
    }

    public String getVerifyTip(String entityName, String permName) {
        return String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RecruchnPermHelper_6", (String)"tsc-tsrbd-business", (Object[])new Object[0]), entityName, permName);
    }

    public String getRecruitChnEditTip() {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u62db\u8058\u6e20\u9053", (String)"RecruchnPermHelper_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u8f91", (String)"RecruchnPermHelper_4", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
    }

    public String getChannelAccountViewTip() {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u6e20\u9053\u8d26\u53f7", (String)"RecruchnPermHelper_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u770b", (String)"RecruchnPermHelper_5", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
    }

    public String getChannelAccountEditTip() {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u6e20\u9053\u8d26\u53f7", (String)"RecruchnPermHelper_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4fee\u6539", (String)"RecruchnPermHelper_4", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
    }

    public String getChannelContractViewTip() {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u6e20\u9053\u5408\u540c", (String)"RecruchnPermHelper_3", (String)"tsc-tsrbd-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u770b", (String)"RecruchnPermHelper_5", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
    }

    public String getChannelContractEditTip() {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u6e20\u9053\u5408\u540c", (String)"RecruchnPermHelper_3", (String)"tsc-tsrbd-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4fee\u6539", (String)"RecruchnPermHelper_4", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
    }

    public String getChannelContactViewTip() {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u6e20\u9053\u8054\u7cfb\u4eba", (String)"RecruchnPermHelper_2", (String)"tsc-tsrbd-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u770b", (String)"RecruchnPermHelper_5", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
    }

    public String getChannelContactEditTip() {
        return this.getVerifyTip(ResManager.loadKDString((String)"\u6e20\u9053\u8054\u7cfb\u4eba", (String)"RecruchnPermHelper_2", (String)"tsc-tsrbd-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4fee\u6539", (String)"RecruchnPermHelper_4", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
    }

    static {
        PERM_MAP.put("view", QUERY_PERM);
        PERM_MAP.put("edit", MODIFY_PERM);
    }

    private static class RecruchnPermHelperHolder {
        private static final RecruchnPermHelper ADVERT_PERM_HELPER = new RecruchnPermHelper();

        private RecruchnPermHelperHolder() {
        }
    }
}

