/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.channel.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.constants.ChannelConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class RecruchnlnmService {
    private static final HRBaseServiceHelper REC_ADD_SERVICE_HELPER = new HRBaseServiceHelper("tsrbd_recruchnlnm_add");
    private static final String LINEFEED = "\\\\r\\\\n";
    private static final String LINEFEED_REPLACE = "\r\n";

    public static boolean checkOpPermission(String entityNum, String permissionStatus) {
        Long userId = TSCRequestContext.getUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"tsrbd", (String)entityNum, (String)permissionStatus);
        return hasPermOrgResult.hasAllOrgPerm() || !hasPermOrgResult.getHasPermOrgs().isEmpty();
    }

    public static boolean checkOpPermission(String entityNum, String permissionStatus, Long orgId) {
        Long userId = TSCRequestContext.getUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"tsrbd", (String)entityNum, (String)permissionStatus);
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return true;
        }
        return !hasPermOrgResult.getHasPermOrgs().isEmpty() && hasPermOrgResult.getHasPermOrgs().contains(orgId);
    }

    public static String getEditFailPermissionError() {
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u62db\u8058\u6e20\u9053\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"RecruchnlnmList_1", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
    }

    public static String getAddFailPermissionError() {
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u62db\u8058\u6e20\u9053\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"RecruchnlnmList_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
    }

    public static QFilter getQFilterRecruchnlnm(List<Long> idList) {
        if (idList == null || idList.size() == 0) {
            idList = Collections.singletonList(1160L);
        }
        QFilter qFilter = new QFilter("id", "in", idList);
        return qFilter;
    }

    public static boolean showDataChangeForm(IFormView view, IFormView parentView, String cacheKey, ConfirmCallBackListener confirmCallBacks) {
        String changeDataMessage = RecruchnlnmService.checkCacheChangeName(view);
        if (HRStringUtils.isNotEmpty((String)changeDataMessage)) {
            String changeDataMessagePrefix = RecruchnlnmService.billIsChange();
            HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), RecruchnlnmService.returnUpdate());
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), RecruchnlnmService.directQuit());
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = RecruchnlnmService.confirmSaveChange();
            msg = msg.replace(LINEFEED, LINEFEED_REPLACE);
            IFormView viewForm = parentView != null ? parentView : view;
            viewForm.showConfirm(msg, changeDataMessagePrefix + changeDataMessage, options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
            return true;
        }
        return false;
    }

    public static String checkCacheChangeName(IFormView view) {
        StringBuilder changeDataMessage = new StringBuilder();
        String cachePreInfoStr = view.getPageCache().get("preinfo_data_cache");
        if (HRStringUtils.isEmpty((String)cachePreInfoStr)) {
            return changeDataMessage.toString();
        }
        JSONObject preInfoJson = JSON.parseObject((String)cachePreInfoStr);
        if (preInfoJson.size() == 0) {
            return changeDataMessage.toString();
        }
        for (String keyField : ChannelConstants.KEY_RECRUCHNM_FIELDS) {
            Object value = view.getModel().getValue(keyField);
            Object filedValue = preInfoJson.get((Object)keyField);
            if (value instanceof Date) {
                value = HRInteDateTimeUtil.formatDate((String)"tsirm_empcv", (String)"createtime", (Date)((Date)value));
            } else if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).get("id");
            }
            if (value instanceof OrmLocaleValue) {
                filedValue = preInfoJson.getJSONObject(keyField).getString("GLang");
            }
            if (filedValue == null || filedValue.toString().equals(value.toString())) continue;
            if (!"".equals(changeDataMessage.toString())) {
                changeDataMessage.append(',');
            }
            changeDataMessage.append(view.getModel().getDataEntityType().findProperty(keyField).getDisplayName());
        }
        return changeDataMessage.toString();
    }

    public static void resetPreInfo(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String cachePreInfoStr = pageCache.get("preinfo_data_cache");
        if (HRStringUtils.isNotEmpty((String)cachePreInfoStr)) {
            JSONObject preInfoJson = JSON.parseObject((String)cachePreInfoStr);
            IDataModel model = view.getModel();
            model.beginInit();
            for (String field : ChannelConstants.KEY_RECRUCHNM_FIELDS) {
                Object ov = preInfoJson.get((Object)field);
                if ("".equals(ov)) {
                    model.setValue(field, null);
                } else {
                    model.setValue(field, ov);
                }
                view.updateView(field);
            }
            model.endInit();
            pageCache.remove("preinfo_data_cache");
        }
    }

    public static String billIsChange() {
        return ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5\uff1a", (String)"tsrbd_bussiness_30", (String)"tsrbd_recruchnlnm", (Object[])new Object[0]);
    }

    public static String returnUpdate() {
        return ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"tsrbd_bussiness_31", (String)"tsrbd_recruchnlnm", (Object[])new Object[0]);
    }

    public static String directQuit() {
        return ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"tsrbd_bussiness_32", (String)"tsrbd_recruchnlnm", (Object[])new Object[0]);
    }

    public static String confirmSaveChange() {
        return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\\r\\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"tsrbd_bussiness_33", (String)"tsrbd_recruchnlnm", (Object[])new Object[0]);
    }

    public static QFilter getAdvertSelectQFilter() {
        QFilter idFilter = new QFilter("id", "=", (Object)ChannelConstants.INTRECO_CHANNEL_ID);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("advertisement", "=", (Object)"D");
        QFilter channelType = new QFilter("resacqmthd.id", "not in", (Object)Lists.newArrayList((Object[])new Long[]{1050L, 1060L, 1080L}));
        QFilter andFilter = typeFilter.and(enableFilter).and(channelType);
        return andFilter.or(idFilter);
    }

    public static QFilter getTsirmAdvertSelectQFilter() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter channelType = new QFilter("resacqmthd.id", "=", (Object)1050L);
        return enableFilter.and(channelType);
    }

    public static DynamicObject[] getTsirmAdvertChannel() {
        return REC_ADD_SERVICE_HELPER.query(new QFilter[]{RecruchnlnmService.getTsirmAdvertSelectQFilter()});
    }

    public static DynamicObject getChannelById(Long pkId) {
        return REC_ADD_SERVICE_HELPER.queryOne((Object)pkId);
    }

    public static CommonBaseDataFilterColumn getCommonBaseDataFilterColumn() {
        CommonBaseDataFilterColumn positionColumn = new CommonBaseDataFilterColumn();
        positionColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4", (String)"AppFileSearchList_3", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0])));
        positionColumn.setFieldName("datarange");
        positionColumn.setEntityField(false);
        positionColumn.setDefaultValue("");
        positionColumn.setEntityType(EntityMetadataCache.getDataEntityType((String)"tsrbd_recruchnlnm"));
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        ComboItem item = new ComboItem();
        String val = ResManager.loadKDString((String)"\u6211\u521b\u5efa\u7684", (String)"AppFileSearchList_2", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]);
        item.setCaption(new LocaleString(val));
        item.setValue(val);
        combos.add(item);
        positionColumn.setComboItems(combos);
        positionColumn.setType("enum");
        return positionColumn;
    }

    public static void setFilter(String parentFormId, SetFilterEvent event) {
        List qFilters = event.getQFilters();
        QFilter qFilterData = null;
        for (QFilter qFilter : qFilters) {
            if (qFilter == null || !"datarange".equals(qFilter.getProperty())) continue;
            qFilterData = qFilter;
        }
        if (qFilterData != null) {
            qFilters.remove(qFilterData);
            qFilters.add(new QFilter("creator", "=", (Object)TSCRequestContext.getUserId()));
        }
        if (parentFormId.equals("tsrbd_recruchnlnm") || parentFormId.equals("tsrbd_recruchnlnmf7ad")) {
            QFilter qFilter = new QFilter("id", "!=", (Object)1180L);
            event.getQFilters().add(qFilter);
        }
        event.setOrderBy("issyspreset desc,createtime desc");
    }
}

