/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.common.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;

public class HRUserService {
    private static final Log logger = LogFactory.getLog(HRUserService.class);

    public static Map<String, Object> getPersonModelIdByUserId(Long userId) {
        Map person = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{userId});
        logger.info("persion info = {}", (Object)person);
        return person;
    }

    public static Long getPersonIdByUserId(Long userId) {
        Object person;
        Object data;
        Long personId = null;
        Map<String, Object> obj = HRUserService.getPersonModelIdByUserId(userId);
        if (obj != null && (data = obj.get("data")) != null && (person = ((Map)data).get("person")) != null) {
            personId = (Long)person;
        }
        return personId;
    }

    public static Long getEmployeeIdByUserId(Long userId) {
        Object employee;
        Object data;
        Map<String, Object> obj = HRUserService.getPersonModelIdByUserId(userId);
        if (obj != null && (data = obj.get("data")) != null && (employee = ((Map)data).get("employee")) != null) {
            return (Long)employee;
        }
        return null;
    }

    public static Map<String, Object> getPersonInfo(Long personId) {
        Map person = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfo", (Object[])new Object[]{personId});
        logger.info("persion info = {}", (Object)person);
        return person;
    }

    public static String getName(Map<String, Object> person) {
        return (String)person.get("name");
    }

    public static String getURL(Map<String, Object> person) {
        String url = (String)person.get("headsculpture");
        return HRImageUrlUtil.getImageFullUrl((String)url);
    }

    public static String getGender(Map<String, Object> person) {
        return (String)person.get("gender");
    }

    public static String getNumber(Map<String, Object> person) {
        return (String)person.get("number");
    }

    public static String getCompany(Map<String, Object> person) {
        return (String)person.get("company");
    }

    public static Long getOrgId(Map<String, Object> person) {
        return (Long)person.get("adminorg_id");
    }

    public static String getAdminorg(Map<String, Object> person) {
        return (String)person.get("adminorg");
    }

    public static String getPosition(Map<String, Object> person) {
        return (String)person.get("position");
    }

    public static List<Long> getPersonPid(List<Long> personIdList) {
        QFilter qFilter = new QFilter("id", "in", personIdList);
        DynamicObject[] hrPiPersons = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"id,personindexid", (QFilter[])new QFilter[]{qFilter});
        Map<Long, Long> personIndexIdMap = Arrays.stream(hrPiPersons).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("personindexid")));
        ArrayList<Long> pids = new ArrayList<Long>(personIndexIdMap.values());
        return pids;
    }
}

