/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.common.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class RecruitmentStageBusiness
extends HRBaseServiceHelper {
    public static final String BASE_STAT_NUMBER_ID = "stat_id";

    public RecruitmentStageBusiness(String entityName) {
        super(entityName);
    }

    public static RecruitmentStageBusiness getInstance() {
        return Instance.INSTANCE;
    }

    public static void deleteStat(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            QFilter[] unBindStgStatQFilter = RecruitmentStageBusiness.getUnBindStgStatQFilter(dataEntity);
            DeleteServiceHelper.delete((String)"tsrbd_recrustatnew", (QFilter[])unBindStgStatQFilter);
        }
    }

    public static QFilter[] getUnBindStgStatQFilter(DynamicObject dataEntity) {
        DynamicObjectCollection stgStatEntry = dataEntity.getDynamicObjectCollection("statselnewentry");
        List statIds = stgStatEntry.stream().map(obj -> obj.getLong(BASE_STAT_NUMBER_ID)).collect(Collectors.toList());
        String statNumberFilterProp = String.join((CharSequence)".", "group", "number");
        QFilter statNumberFilter = new QFilter(statNumberFilterProp, "=", (Object)dataEntity.getString("number"));
        QFilter statIdFilter = new QFilter("id", "not in", statIds);
        QFilter queryFilter = statIdFilter.and(statNumberFilter);
        return queryFilter.toArray();
    }

    public static Map<Long, DynamicObject> getDyMapByPkList(Object[] pkArray) {
        DynamicObject[] dynamicObjects = Instance.INSTANCE.loadDynamicObjectArray(pkArray);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            resultMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        return resultMap;
    }

    public static DynamicObject getStageByNumber(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        return Instance.INSTANCE.loadDynamicObject(filter);
    }

    public static DynamicObject[] getStageByPks(Object[] toArray) {
        return Instance.INSTANCE.loadDynamicObjectArray(toArray);
    }

    public static DynamicObject getStageByPkId(Long pkId) {
        return Instance.INSTANCE.loadSingle(pkId);
    }

    private static class Instance {
        private static final RecruitmentStageBusiness INSTANCE = new RecruitmentStageBusiness("tsrbd_recrustgnew");

        private Instance() {
        }
    }
}

