/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.common.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ServiceHelperCache {
    private static final int MAX_SIZE = 1000;
    private static final int EXPIRE_AFTER_WRITE_TIME = 30;
    private static Cache<String, HRBaseServiceHelper> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.MINUTES).weakValues().build();

    public static HRBaseServiceHelper getHrBaseServiceHelper(String entryName) {
        try {
            return (HRBaseServiceHelper)cache.get((Object)entryName, () -> new HRBaseServiceHelper(entryName));
        }
        catch (ExecutionException e) {
            ErrorCode errorCode = new ErrorCode("ServiceHelperCache.getHrBaseServiceHelper", "ServiceHelperCache.getHrBaseServiceHelper" + e);
            throw new KDException(errorCode, new Object[0]);
        }
    }
}

