/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.config.bizconfig.template;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.util.CodeRuleInfoUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.config.bizconfig.template.BizConfigCache;
import kd.tsc.tsrbd.common.enums.ShowForm;
import kd.tsc.tsrbd.common.enums.ShowList;

public class BizConfigUtils {
    private static final Log logger = LogFactory.getLog(BizConfigUtils.class);
    private static final int FIELD_DATA_LENGTH = 5000;
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_NAME = "formId";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final HRBaseServiceHelper dataHelper = new HRBaseServiceHelper("tsrbd_businessconfigdata");
    private final BizConfigCache bizConfigCache = new BizConfigCache();
    public static final String BIZ_CONFIG_FORM_ID = "tsrbd_businessconfig";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String PAGE_CACHE_TRUE = "1";
    public static final String PAGE_CACHE_FALSE = "0";
    public static final String SHOW_LIST = "showList";
    public static final String SHOW_FORM = "showForm";

    public static void cacheForms(IFormView view) {
        try {
            view.getPageCache().put(SHOW_LIST, MAPPER.writeValueAsString(BizConfigUtils.getShowMap(ShowList.class, view)));
            view.getPageCache().put(SHOW_FORM, MAPPER.writeValueAsString(BizConfigUtils.getShowMap(ShowForm.class, view)));
        }
        catch (JsonProcessingException ex) {
            logger.error("cacheForms error", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public static Map<String, String> getShowMap(IFormView view) {
        Map<String, String> map = BizConfigUtils.getShowMap(SHOW_LIST, view);
        map.putAll(BizConfigUtils.getShowMap(SHOW_FORM, view));
        return map;
    }

    public static <T> Map<String, String> getShowMap(Class<T> type, IFormView view) {
        try {
            HashMap map = Maps.newHashMapWithExpectedSize((int)type.getEnumConstants().length);
            Field field = type.getDeclaredField(FIELD_NAME);
            for (T cons : type.getEnumConstants()) {
                String containerKey = ((Enum)cons).name().toLowerCase();
                String formId = (String)field.get(cons);
                map.put(containerKey, formId);
                Optional.ofNullable(view.getControl(containerKey)).map(con -> ((Container)con).getItems()).ifPresent(items -> items.forEach(item -> map.put(item.getKey(), formId)));
            }
            return map;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("getShowMap error", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public static Map<String, String> getShowMap(String key, IFormView view) {
        try {
            return (Map)MAPPER.readValue(view.getPageCache().get(key), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            logger.error("getShowMap(String, IFormView) error", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    public static String getMustInputEmptyFields(IFormView view) {
        Map fields = EntityMetadataCache.getDataEntityType((String)view.getFormShowParameter().getFormId()).getAllFields();
        DynamicObject dataEntity = view.getModel().getDataEntity();
        Set<String> mustInputFields = BizConfigUtils.getViewMustInputFields(view);
        return fields.values().stream().filter(prop -> !PAGE_CACHE_FALSE.equals(view.getPageCache().get(BizConfigUtils.getVisibleKey(prop.getName()))) && mustInputFields.contains(prop.getName()) && prop.isEmpty((Object)dataEntity)).map(data -> data.getDisplayName().getLocaleValue()).collect(Collectors.joining("\u3001"));
    }

    public static String getVisibleKey(String key) {
        return key + ".visible";
    }

    public static boolean isMustInput(IDataEntityProperty property) {
        if (property instanceof FieldProp) {
            return ((FieldProp)property).isMustInput();
        }
        if (property instanceof BasedataProp) {
            return ((BasedataProp)property).isMustInput();
        }
        if (property instanceof MulBasedataProp) {
            return ((MulBasedataProp)property).isMustInput();
        }
        return false;
    }

    public static Set<String> getViewMustInputFields(IFormView formView) {
        HashSet<String> mustInputFields = new HashSet<String>();
        DynamicObject dynamicObjectPage = formView.getModel().getDataEntity();
        DataEntityPropertyCollection properties = dynamicObjectPage.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            boolean isMustInput = false;
            String mustInputCondition = null;
            if (property instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)property;
                isMustInput = fieldProp.isMustInput();
                mustInputCondition = fieldProp.getMustInputCondition();
            } else if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                isMustInput = basedataProp.isMustInput();
                mustInputCondition = basedataProp.getMustInputCondition();
            } else if (property instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                isMustInput = mulBasedataProp.isMustInput();
                mustInputCondition = mulBasedataProp.getMustInputCondition();
            } else if (property instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)property;
                isMustInput = entryProp.isEntryMustInput();
            }
            if (isMustInput && HRStringUtils.isNotEmpty((String)mustInputCondition)) {
                CodeRuleInfo codeRuleInfo = new CodeRuleInfo();
                codeRuleInfo.setEnableCondition(mustInputCondition);
                isMustInput = CodeRuleInfoUtil.isMatchConditions((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynamicObjectPage);
            }
            if (!isMustInput) continue;
            mustInputFields.add(property.getName());
        }
        return mustInputFields;
    }

    public static ObjectNode getObjectNode(IFormView view) {
        Map fields = EntityMetadataCache.getDataEntityType((String)view.getFormShowParameter().getFormId()).getAllFields();
        DynamicObject dataEntity = view.getModel().getDataEntity();
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        for (Map.Entry entry : fields.entrySet()) {
            String key = (String)entry.getKey();
            if (PAGE_CACHE_FALSE.equals(view.getPageCache().get(BizConfigUtils.getVisibleKey(key)))) continue;
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            Object val = property.getValue((Object)dataEntity);
            if (val instanceof Integer) {
                node.put(key, (Integer)val);
                continue;
            }
            if (val instanceof Long) {
                node.put(key, (Long)val);
                continue;
            }
            if (val instanceof BigDecimal) {
                node.put(key, (BigDecimal)val);
                continue;
            }
            if (val instanceof Date) {
                node.put(key, format.format(val));
                continue;
            }
            if (val instanceof DynamicObject) {
                node.put(key, (Long)((DynamicObject)val).getPkValue());
                continue;
            }
            if (val instanceof DynamicObjectCollection) {
                ArrayNode array = node.putArray(key);
                ((DynamicObjectCollection)val).forEach(dy -> array.add((Long)dy.getDynamicObject("fbasedataid").getPkValue()));
                continue;
            }
            node.put(key, String.valueOf(val));
        }
        return node;
    }

    public static Map<String, Object> getFormData(String formId, String json) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(json);
            Map fields = EntityMetadataCache.getDataEntityType((String)formId).getAllFields();
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            for (Map.Entry<String, IDataEntityProperty> entry : fields.entrySet()) {
                JsonNode val = jsonNode.get((String)entry.getKey());
                if (val == null) continue;
                map.put((String)entry.getKey(), BizConfigUtils.getValue(val, format, entry));
            }
            return map;
        }
        catch (Exception e) {
            logger.error("getFormData error", (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static Object getValue(JsonNode val, SimpleDateFormat format, Map.Entry<String, IDataEntityProperty> entry) throws ParseException {
        Class type = entry.getValue().getPropertyType();
        if (type == Integer.class) {
            return val.asInt();
        }
        if (type == Long.class) {
            return val.asLong();
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(val.asText());
        }
        if (type == Date.class) {
            return format.parse(val.asText());
        }
        if (entry.getValue() instanceof MulBasedataProp) {
            return BizConfigUtils.mulBasedataIds(val);
        }
        return val.asText();
    }

    private static Object[] mulBasedataIds(JsonNode node) {
        if (node.isArray()) {
            Object[] ids = new Object[node.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = node.get(i).asLong();
            }
            return ids;
        }
        return new Object[0];
    }

    public void clearData(IFormView view) {
        EntityMetadataCache.getDataEntityType((String)view.getFormShowParameter().getFormId()).getAllFields().keySet().forEach(field -> view.getModel().setValue(field, null));
    }

    public void bindData(IFormView view) {
        String formId = view.getFormShowParameter().getFormId();
        DynamicObject bizData = this.queryBusinessData(formId);
        if (bizData == null) {
            return;
        }
        Map<String, Object> map = BizConfigUtils.getFormData(formId, bizData.getString(FIELD_DATA));
        map.forEach((key, value) -> view.getModel().setValue(key, map.get(key)));
    }

    public void save(String key, String json) {
        try (TXHandle tx = TX.required();){
            DynamicObject data = this.queryBusinessData(key);
            if (data == null) {
                data = this.dataHelper.generateEmptyDynamicObject();
                data.set(FIELD_NUMBER, (Object)key);
            }
            data.set(FIELD_DATA, (Object)json);
            this.dataHelper.saveOne(data);
            tx.commit();
        }
    }

    public void save(IFormView view) {
        try (TXHandle tx = TX.required();){
            String json = new ObjectMapper().writeValueAsString((Object)BizConfigUtils.getObjectNode(view));
            if (json.length() > 5000) {
                throw new KDException(new ErrorCode("", "Data size is over the limit"), new Object[0]);
            }
            HRBaseServiceHelper dataHelper = new HRBaseServiceHelper("tsrbd_businessconfigdata");
            DynamicObject data = this.queryBusinessData(view.getFormShowParameter().getFormId());
            if (data == null) {
                data = dataHelper.generateEmptyDynamicObject();
                data.set(FIELD_NUMBER, (Object)view.getFormShowParameter().getFormId());
            }
            data.set(FIELD_DATA, (Object)json);
            dataHelper.saveOne(data);
            this.bizConfigCache.remove(view.getFormShowParameter().getFormId());
        }
    }

    public DynamicObject queryBusinessData(String formId) {
        return this.dataHelper.queryOne(FIELD_DATA, new QFilter(FIELD_NUMBER, "=", (Object)formId));
    }
}

