/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.gpt;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.tsc.tsrbd.extpoint.gpt.IGptCustomParamService;

public class GptCustomParamService {
    private static final Log LOG = LogFactory.getLog(GptCustomParamService.class);
    private static final GptCustomParamService GPT_CUSTOM_PARAM_SERVICE = new GptCustomParamService();

    private GptCustomParamService() {
    }

    public static GptCustomParamService getInstance() {
        return GPT_CUSTOM_PARAM_SERVICE;
    }

    public void setCustomPositionJdTitle(Map<String, String> titleMap) {
        LOG.info("kd.tsc.tsrbd.business.domain.gpt.GptCustomParamService->setCustomPositionJdTitle");
        HRPluginProxy<IGptCustomParamService> serviceProxy = this.getCustomParamServiceProxy();
        serviceProxy.callAfter(service -> {
            if (null != service) {
                service.setCustomPositionJdTitle(titleMap);
            }
            return null;
        });
    }

    public long getGptId(DynamicObject dynamicObject) {
        LOG.info("kd.tsc.tsrbd.business.domain.gpt.GptCustomParamService->getGptId");
        HRPluginProxy<IGptCustomParamService> serviceProxy = this.getCustomParamServiceProxy();
        AtomicLong gptId = new AtomicLong(0L);
        serviceProxy.callAfter(service -> {
            if (service != null) {
                gptId.addAndGet(service.setCustomGptId(dynamicObject));
            }
            return null;
        });
        return gptId.get();
    }

    public void toExtGptCustomParam(long gptId, Map<String, String> param, DynamicObject dynamicObject) {
        if (null == param || null == dynamicObject) {
            return;
        }
        this.setCustomParam(gptId, param, dynamicObject);
    }

    private void setCustomParam(long gptId, Map<String, String> param, DynamicObject dynamicObject) {
        LOG.info("kd.tsc.tsrbd.business.domain.gpt.GptCustomParamService->setCustomParam");
        HRPluginProxy<IGptCustomParamService> serviceProxy = this.getCustomParamServiceProxy();
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.addOrUpdateCustomParam(gptId, param, dynamicObject);
            }
            return null;
        });
    }

    private HRPluginProxy<IGptCustomParamService> getCustomParamServiceProxy() {
        return HRPlugInProxyFactory.create(null, IGptCustomParamService.class, (String)"kd.sdk.tsc.tsrbd.extpoint.gpt.IGptCustomParamService", null);
    }
}

