/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.headtemplate;

import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.headtemplate.HeaderService;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHeaderService
implements HeaderService {
    private static final long serialVersionUID = -6433393034342892431L;
    protected final Log logger = LogFactory.getLog(AbstractHeaderService.class);
    protected String DATA_FORMAT = "yyyy-MM-dd HH:mm";
    protected String UTC = " UTC";
    protected String APPLY_TIME = "delivery.applytime";

    protected void setDeliveryInfo(IDataModel model, Object rsmId) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tstpm_rsm");
        DynamicObject rsm = helper.loadSingle(rsmId);
        model.setValue("dlychannel", (Object)rsm.getString("delivery.recruchnlnm.name"));
        if (rsm.getDate(this.APPLY_TIME) == null) {
            return;
        }
        Calendar ca = Calendar.getInstance();
        TimeZone tz = ca.getTimeZone();
        String zoneId = tz.toZoneId().getRules().getStandardOffset(Instant.now()).getId();
        String applyTime = HRDateTimeUtils.format((Date)rsm.getDate(this.APPLY_TIME), (String)this.DATA_FORMAT);
        model.setValue("applytime", (Object)(applyTime + this.UTC + zoneId));
    }

    protected void setStdRsmInfo(IFormView view, Long stdRsmId) {
        if (stdRsmId == 0L) {
            return;
        }
        Label label = (Label)view.getControl("labelap");
        Set<Long> set = AbstractHeaderService.getSimilarByStdRsmId(stdRsmId);
        if (set.isEmpty()) {
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap7"});
        } else {
            String num = set.size() == 1 ? "" : String.valueOf(set.size());
            label.setText("\u7591\u4f3c " + num);
        }
        DynamicObject stdRsm = AbstractHeaderService.getStdRsmByMid(stdRsmId);
        if (stdRsm == null) {
            return;
        }
        String dataStatus = stdRsm.getString("datastatus");
        if (!ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap71", "blacklisticon"});
        }
    }

    public static DynamicObject getStdRsmByMid(Long stdRsmId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tstpm_stdrsm");
        DynamicObject rsm = helper.loadSingle((Object)stdRsmId);
        if (HRObjectUtils.isEmpty((Object)rsm)) {
            return null;
        }
        if (rsm.getLong("id") != rsm.getLong("mid")) {
            QFilter filter = new QFilter("id", "=", (Object)rsm.getLong("mid"));
            rsm = helper.loadDynamicObject(filter);
        }
        return rsm;
    }

    public static Set<Long> getSimilarByStdRsmId(Long stdRsmId) {
        QFilter filter = new QFilter("stdrsm", "=", (Object)stdRsmId).and(new QFilter("duplicatetype", "=", (Object)"1"));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tstpm_stdrsmsimilar");
        DynamicObject[] dys = helper.query("stdrsm,similarrsm,stdrsmhis,duplicatetype", new QFilter[]{filter});
        return Arrays.stream(dys).map(dy -> dy.getLong("similarrsm")).collect(Collectors.toSet());
    }

    protected void openSuspectedPage(IFormView view, Long stdRsmId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setPageId(view.getPageId() + "tstpm_suspected");
        formShowParameter.setFormId("tstpm_suspected");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)stdRsmId);
        view.showForm(formShowParameter);
    }

    protected void openBlacklistInfoPage(IFormView view, Long stdRsmId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("tstpm_blacklistdetail");
        fsp.setCaption(ResManager.loadKDString((String)"\u9ed1\u540d\u5355\u8be6\u60c5", (String)"HeadInfoPlugin_2", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.NonModal);
        fsp.setCustomParam("stdrsm.id", (Object)stdRsmId);
        view.showForm(fsp);
    }

    protected void setPhoto(IFormView view, String photoUrl) {
        Image photo = (Image)view.getControl("photo");
        if (ObjectUtils.isNotEmpty((Object)photoUrl)) {
            photo.setUrl(HRImageUrlUtil.getImageFullUrl((String)photoUrl));
        } else {
            photo.setUrl("/images/pc/emotion/default_person_82_82.png");
        }
        IFormView parentView = view.getParentView();
        if (null != parentView) {
            String formId = parentView.getFormShowParameter().getFormId();
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"tssrm_appfile_view") || StringUtils.equals((CharSequence)formId, (CharSequence)"tssrm_appfile_viewm")) {
                Object pkId = view.getFormShowParameter().getCustomParam("id");
                HRBaseServiceHelper appFileHelper = ServiceHelperCache.getHrBaseServiceHelper("tspr_appfile");
                DynamicObject appFile = appFileHelper.queryOne(pkId);
                String appFileStatus = appFile.getString("filestatus");
                if (StringUtils.equals((CharSequence)"A", (CharSequence)appFileStatus) || StringUtils.equals((CharSequence)"D", (CharSequence)appFileStatus)) {
                    view.setEnable(Boolean.TRUE, new String[]{"photo"});
                } else {
                    view.setEnable(Boolean.FALSE, new String[]{"photo"});
                }
            } else {
                view.setEnable(Boolean.FALSE, new String[]{"photo"});
                ImmutableMap ctrlMap = ImmutableMap.of((Object)"clickable", (Object)Boolean.FALSE);
                view.updateControlMetadata("flexpanelap13", (Map)ctrlMap);
            }
        }
    }

    protected void setPhotoHide(IFormView view, boolean hide) {
        Image resumePic = (Image)view.getControl("photo");
        if (hide) {
            resumePic.setTips(null);
            view.setEnable(Boolean.FALSE, new String[]{"flexpanelap3"});
        }
    }
}

