/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.home;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.HRUserService;
import kd.tsc.tsrbd.common.enums.RecruitType;
import org.apache.commons.collections4.MapUtils;

public class HomePageService {
    private static final Log LOG = LogFactory.getLog(HomePageService.class);
    private static final long LABRELSTATUSPRD = 1010L;

    public Map<String, Long> getResumeFilterDataCount(RecruitType recruitType) {
        if (recruitType == null) {
            return new HashMap<String, Long>();
        }
        switch (recruitType) {
            case INNER_RECRUIT: {
                String serviceName = "IResumeFilterService";
                String methodName = "getResumeFilterDataCount";
                Map dataCount = (Map)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tsirm", (String)"IResumeFilterService", (String)"getResumeFilterDataCount", (Object[])new Object[0]);
                LOG.info("HomePageService.getResumeFilterDataCount result {}", (Object)dataCount);
                return dataCount;
            }
        }
        return Maps.newHashMap();
    }

    public Map<String, Long> getIntverviewMap(RecruitType recruitType) {
        if (recruitType == null) {
            return new HashMap<String, Long>();
        }
        switch (recruitType) {
            case INNER_RECRUIT: {
                String serviceName = "IInterviewCalendarService";
                String methodName = "getIntverviewMap";
                Map dataCount = (Map)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tsirm", (String)"IInterviewCalendarService", (String)"getIntverviewMap", (Object[])new Object[0]);
                LOG.info("HomePageService.getIntverviewMap result {}", (Object)dataCount);
                return dataCount;
            }
        }
        return Maps.newHashMap();
    }

    public DynamicObject[] listTodayInterviewEvl(RecruitType recruitType) {
        if (RecruitType.INNER_RECRUIT.number.equals(recruitType.number)) {
            String serviceName = "IInterviewCalendarService";
            String methodName = "listTodayInterviewEvl";
            DynamicObject[] listTodayInterviewData = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tsirm", (String)"IInterviewCalendarService", (String)"listTodayInterviewEvl", (Object[])new Object[0]);
            if (listTodayInterviewData != null) {
                for (DynamicObject listTodayInterviewDatum : listTodayInterviewData) {
                    LOG.info("HomePageService.listTodayInterviewEvl id {}", listTodayInterviewDatum.getPkValue());
                }
            }
            return listTodayInterviewData;
        }
        return new DynamicObject[0];
    }

    public boolean getInterviewCheckCondition(RecruitType recruitType) {
        if (recruitType == null) {
            return false;
        }
        switch (recruitType) {
            case INNER_RECRUIT: {
                Long employeeId = HRUserService.getEmployeeIdByUserId(UserServiceHelper.getCurrentUserId());
                LOG.info("HomePageService.getInterviewCheckCondition employeeId : {} userId : {}", (Object)employeeId, (Object)UserServiceHelper.getCurrentUserId());
                DynamicObject laborRelStatusObj = this.getEmployeeLaborRelStatus(employeeId);
                LOG.info("HomePageService.getInterviewCheckCondition laborRelStatusObj : {} userId : {}", (Object)laborRelStatusObj, (Object)UserServiceHelper.getCurrentUserId());
                if (Objects.isNull(laborRelStatusObj)) {
                    return false;
                }
                long labrelstatusprdId = laborRelStatusObj.getLong("labrelstatusprd.id");
                LOG.info("HomePageService.getInterviewCheckCondition labrelstatusprdId -> {}", (Object)labrelstatusprdId);
                return labrelstatusprdId == 1010L;
            }
            case CAMPUS_RECRUIT: {
                return false;
            }
            case SOCIETY_RECRUIT: {
                return false;
            }
        }
        return false;
    }

    private DynamicObject getEmployeeLaborRelStatus(Long employeeId) {
        Map laborRelStatusMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployeeStatus", (Object[])new Object[]{Collections.singletonList(employeeId)});
        if (MapUtils.isEmpty((Map)laborRelStatusMap)) {
            return null;
        }
        return (DynamicObject)laborRelStatusMap.get(employeeId);
    }

    public List<Object> getIntvCalendarLists(Date startTime, Date endTime, RecruitType recruitType) {
        if (recruitType == null) {
            return new ArrayList<Object>();
        }
        switch (recruitType) {
            case INNER_RECRUIT: {
                String serviceName = "IInterviewCalendarService";
                String methodName = "getInterviewCalendarList";
                List calendarList = (List)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tsirm", (String)"IInterviewCalendarService", (String)"getInterviewCalendarList", (Object[])new Object[]{startTime, endTime});
                LOG.info("HomePageService.getIntvCalendarLists param ({},{}) result {}", new Object[]{startTime, endTime, calendarList});
                return calendarList;
            }
        }
        return null;
    }

    public static enum Singleton {
        INSTANCE;

        private final HomePageService instance = new HomePageService();

        public HomePageService getInstance() {
            return this.instance;
        }
    }
}

