/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.interview.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.interview.service.InterviewService;
import org.apache.commons.lang3.ArrayUtils;

public class InterviewQualifyService {
    private static final Log logger = LogFactory.getLog(InterviewQualifyService.class);

    public static String getEntityName() {
        return "tsrbd_interviewqualify";
    }

    public static DynamicObject queryOne(Object pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(InterviewQualifyService.getEntityName());
        return serviceHelper.queryOne(pkId);
    }

    public static void updateDatas(DynamicObject[] dobjs) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(InterviewQualifyService.getEntityName());
        serviceHelper.updateDatas(dobjs);
    }

    public static List<DynamicObject> selectByIdList(List<Long> idList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(InterviewQualifyService.getEntityName());
        Object[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray((Object[])idList.toArray(new Long[idList.size()]));
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(dynamicObjects.length);
        return Collections.addAll(list, dynamicObjects) ? list : Collections.emptyList();
    }

    public static Map<Long, String> getQualifyErrorMap(List<Long> idList) {
        List<DynamicObject> list = InterviewQualifyService.selectByIdList(idList);
        Date now = new Date();
        HashMap<Long, String> errorMap = new HashMap<Long, String>();
        for (int i = 0; i < list.size(); ++i) {
            String errMsg = null;
            DynamicObject interviewQualify = list.get(i);
            Long id = (Long)interviewQualify.getPkValue();
            Date expireTime = interviewQualify.getDate("expiretime");
            String enable = interviewQualify.getString("enable");
            if ("0".equals(enable)) {
                errMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u540e\u518d\u5ef6\u671f\u3002", (String)"InterviewerHelper_7", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
            } else if (expireTime.getTime() < now.getTime()) {
                errMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u5ef6\u671f\u5931\u8d25", (String)"InterviewerHelper_2", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
            } else if (DateUtils.addMonths((Date)expireTime, (int)-1).getTime() > now.getTime()) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u8ddd\u79bb\u5230\u671f\u65e530\u5929\u5185\u518d\u64cd\u4f5c", (String)"InterviewerHelper_3", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
            }
            if (errMsg == null) continue;
            errorMap.put(id, errMsg);
        }
        return errorMap;
    }

    public static void sendMessages(List<DynamicObject> list) {
        try {
            if (list != null) {
                for (DynamicObject dynamicObject : list) {
                    Object interivewId = dynamicObject.getDynamicObject("interviewid").getPkValue();
                    DynamicObject interview = InterviewService.queryOne(interivewId);
                    if (interview == null) continue;
                    DynamicObject user = interview.getDynamicObject("user");
                    Long userId = (Long)user.getPkValue();
                    String userName = user.getString("name");
                    InterviewQualifyService.sendMessage("\u60a8\u7684\u9762\u8bd5\u5b98\u8d44\u8d28\u5df2\u5ef6\u671f", "\u60a8\u7684\u9762\u8bd5\u5b98\u8d44\u8d28\u5df2\u5ef6\u671f\uff01", userId, UserServiceHelper.getCurrentUserId(), "\u5ef6\u671f\u901a\u77e5", userName);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void sendMessage(String title, String content, Long interviewid, long senderId, String tag, String userName) {
        MessageInfo message = new MessageInfo();
        message.setType("notice");
        message.setNotifyType("sysnotice");
        message.setTitle(title);
        ArrayList<Long> interviewids = new ArrayList<Long>();
        interviewids.add(interviewid);
        message.setUserIds(interviewids);
        if (senderId == 0L) {
            message.setSenderId(Long.valueOf(0L));
        } else {
            message.setSenderId(Long.valueOf(senderId));
        }
        message.setTag(title);
        message.setContent("\u3010" + userName + "\u3011" + content);
        message.setTag(tag);
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        message.setParams((Map)param);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static DynamicObject[] getInterviewAllQualify(long personId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_interviewqualify");
        QFilter[] qFilters = new QFilter[3];
        qFilters[0] = new QFilter("personid", "=", (Object)personId);
        qFilters[1] = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public static DynamicObject[] getInterviewActiveQualify(long personId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_interviewqualify");
        QFilter[] qFilters = new QFilter[]{new QFilter("personid", "=", (Object)personId), new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("expiretime", ">", (Object)new Date())};
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public static String getIntvertypeName(DynamicObject dynamicObject) {
        return dynamicObject.getDynamicObject("intvertypeid").getString("name");
    }

    public static DynamicObject[] getInterviewActiveQualifyByUserId(long userid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_interviewqualify");
        QFilter[] qFilters = new QFilter[]{new QFilter("user", "=", (Object)userid), new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("expiretime", ">", (Object)new Date())};
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public static DynamicObject[] getInterviewQualify(long personId, Long interviewTypeid, Long recrutypid) {
        return InterviewQualifyService.getInterviewQualify(personId, interviewTypeid, recrutypid, Boolean.TRUE);
    }

    public static DynamicObject[] getInterviewQualify(long personId, Long interviewTypeid, Long recrutypid, Boolean enable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_interviewqualify");
        QFilter[] qFilters = new QFilter[5];
        qFilters[0] = new QFilter("personid", "=", (Object)personId);
        qFilters[1] = new QFilter("intvertypeid", "=", (Object)interviewTypeid);
        qFilters[2] = new QFilter("recrutypid", "=", (Object)recrutypid);
        qFilters[3] = new QFilter("expiretime", ">", (Object)new Date());
        if (Boolean.TRUE == enable) {
            qFilters[4] = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        }
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public static DynamicObject[] getInterviewQualify(long personId, String isOverTime) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_interviewqualify");
        QFilter[] qFilters = new QFilter[3];
        qFilters[0] = new QFilter("personid", "=", (Object)personId);
        qFilters[1] = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        if (isOverTime == null) {
            qFilters[2] = new QFilter("expiretime", ">", (Object)new Date());
        }
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }
}

