/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.interviewer.helper;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.interviewer.entity.Intverfileentry;
import kd.tsc.tsrbd.business.domain.interviewer.helper.InterviewerDBHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class InterviewerHelper {
    private static final Map<String, String> PERM_MAP = new HashMap<String, String>(16);
    public static final String DELAYENTRY = "260F4ZC0YAXI";
    public static final String DELAYE = "delaye";
    private static final Log LOGGER = LogFactory.getLog(InterviewerHelper.class);

    public static void openIntverPage(IFormView view, long pkId) {
        DynamicObject interviewerEntry = InterviewerDBHelper.getInterviewerFileEntry(pkId, "tsrbd_intverfileentry");
        long fileId = interviewerEntry.getDynamicObject("intverfile").getLong("masterid");
        DynamicObject intervieFile = InterviewerDBHelper.getInterviewerFileEntry(fileId, "tsrbd_intverfile");
        DynamicObject bosUser = intervieFile.getDynamicObject("user");
        long userId = bosUser.getLong("id");
        String userName = bosUser.getString("name");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsivm_intverfileview");
        showParameter.setCaption(ResManager.loadKDString((String)"\u9762\u8bd5\u5b98-", (String)"InterviewerHelper_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]) + userName);
        showParameter.setCustomParam("userid", (Object)userId);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        view.showForm(showParameter);
    }

    public static void openIntverDetailPage(IFormView view, long pkId) {
        DynamicObject interviewerEntry = InterviewerDBHelper.getInterviewerFileEntry(pkId, "tsrbd_intverfileentry");
        long fileId = interviewerEntry.getDynamicObject("intverfile").getLong("id");
        DynamicObject intervieFile = InterviewerDBHelper.getInterviewerFileEntry(fileId, "tsrbd_intverfile");
        DynamicObject bosUser = intervieFile.getDynamicObject("user");
        long userId = bosUser.getLong("id");
        String userName = bosUser.getString("name");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsivm_intverdetailsview");
        showParameter.setCaption(interviewerEntry.getString("intvertypename") + userName);
        showParameter.setCustomParam("userid", (Object)userId);
        showParameter.setCustomParam("entryid", (Object)pkId);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        view.showForm(showParameter);
    }

    public static void openIntverLevlePage(IFormView view, String applyNumber, String intvertypeName, String intverlevelname) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsivm_intverlevelview");
        showParameter.setCaption(intvertypeName + intverlevelname);
        showParameter.setCustomParam("applynumber", (Object)applyNumber);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        view.showForm(showParameter);
    }

    public static void openIntverapplyPage(IFormView view, long pkId) {
        DynamicObject intervieApply = InterviewerDBHelper.getInterviewerFileEntry(pkId, "tsivm_intverapply");
        DynamicObject bosUser = intervieApply.getDynamicObject("applyuser");
        String userName = bosUser.getString("name");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsivm_intverapply");
        showParameter.setCaption(userName + ResManager.loadKDString((String)"\u7684\u9762\u8bd5\u5b98\u7533\u8bf7", (String)"InterviewerHelper_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        showParameter.setPkId((Object)pkId);
        showParameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)showParameter);
    }

    public static Map<String, String> getPosition(DynamicObjectCollection departmenttab) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String position = "";
        String dpt = "";
        for (DynamicObject department : departmenttab) {
            if (department.getBoolean("ispartjob")) continue;
            position = department.getString("position");
            dpt = department.getDynamicObject("dpt").getString("name");
            break;
        }
        map.put("position", position);
        map.put("dept", dpt);
        return map;
    }

    public static List<Map<String, Object>> getIntvRange(String applyNumber) {
        ArrayList<Map<String, Object>> jobClassList = new ArrayList<Map<String, Object>>(16);
        DynamicObject intverapply = InterviewerDBHelper.getIntverapplyByNo(applyNumber);
        DynamicObjectCollection jobentity = intverapply.getDynamicObjectCollection("jobentity");
        ((DynamicObject)intverapply.getDynamicObjectCollection("jobentity").get(0)).get("jobfamilyname");
        for (DynamicObject dynamicObject : jobentity) {
            HashMap<String, Object> jobClassMap = new HashMap<String, Object>(16);
            jobClassMap.put("jobfamilyhrname", dynamicObject.get("jobfamilyname"));
            jobClassMap.put("jobclasshrname", dynamicObject.get("jobclassname"));
            jobClassMap.put("lowjoblevel", dynamicObject.get("lowjoblevelname"));
            jobClassMap.put("highjoblevel", dynamicObject.get("highjoblevelname"));
            jobClassList.add(jobClassMap);
        }
        return jobClassList;
    }

    public static List<Intverfileentry> getIntverByUserId(long userId, String isOverTime) {
        DynamicObject interviewerFile = InterviewerDBHelper.getInterviewerFileByUserId(userId);
        if (interviewerFile == null) {
            return null;
        }
        DynamicObject[] fileentrys = InterviewerDBHelper.getFileentryByFileId(interviewerFile.getLong("id"), isOverTime);
        ArrayList<Intverfileentry> returnList = new ArrayList<Intverfileentry>(fileentrys.length);
        HashMap<String, String> typenameMap = new HashMap<String, String>(16);
        for (DynamicObject fileentry : fileentrys) {
            Intverfileentry intverfileentry = InterviewerHelper.getIntverfileentry(fileentry);
            if (typenameMap.get(fileentry.getString("intvertypename")) == null) {
                returnList.add(intverfileentry);
            }
            typenameMap.put(fileentry.getString("intvertypename"), fileentry.getString("intvertypename"));
        }
        return returnList;
    }

    private static Intverfileentry getIntverfileentry(DynamicObject fileentry) {
        Intverfileentry intverfileentry = new Intverfileentry();
        intverfileentry.setApplyid(fileentry.getLong("applyid"));
        intverfileentry.setApplynumber(fileentry.getString("applynumber"));
        intverfileentry.setIntverlevelid(fileentry.getLong("intverlevelid"));
        intverfileentry.setEfftime(DateUtils.formatDate((Date)fileentry.getDate("efftime"), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss.sss"}));
        intverfileentry.setIntverlevelname(fileentry.getString("intverlevelname"));
        intverfileentry.setIntvertypeid(fileentry.getLong("intvertypeid"));
        intverfileentry.setIntvertypename(fileentry.getString("intvertypename"));
        intverfileentry.setExpiretime(DateUtils.formatDate((Date)fileentry.getDate("expiretime"), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss.sss"}));
        intverfileentry.setEntryid(fileentry.getLong("id"));
        return intverfileentry;
    }

    public static List<Intverfileentry> getALLIntverByUserId(long userId, String isOverTime) {
        DynamicObject interviewerFile = InterviewerDBHelper.getInterviewerFileByUserId(userId);
        if (interviewerFile == null) {
            return new ArrayList<Intverfileentry>(1);
        }
        DynamicObject[] fileentrys = InterviewerDBHelper.getFileentryByFileId(interviewerFile.getLong("id"), isOverTime);
        ArrayList<Intverfileentry> returnList = new ArrayList<Intverfileentry>(fileentrys.length);
        for (DynamicObject fileentry : fileentrys) {
            Intverfileentry intverfileentry = InterviewerHelper.getIntverfileentry(fileentry);
            returnList.add(intverfileentry);
        }
        return returnList;
    }

    public static void delayEntry(Object[] pkIds, IFormView view, String appdealy, List<Pair<Long, List<String>>> listPair) {
        boolean tail = false;
        if (pkIds.length == 1) {
            tail = true;
        }
        int errNum = 0;
        int sucNum = 0;
        StringBuilder showConfirmStr = new StringBuilder();
        Date now = new Date();
        for (Object pkId : pkIds) {
            String errMsg;
            DynamicObject interviewerEntry = InterviewerDBHelper.getInterviewerFileEntry(pkId, "tsrbd_intverfileentry");
            long intverfileId = interviewerEntry.getDynamicObject("intverfile").getLong("id");
            DynamicObject intverfileEntry = InterviewerDBHelper.getInterviewerFileEntry(intverfileId, "tsrbd_intverfile");
            long userId = intverfileEntry.getDynamicObject("user").getLong("id");
            String userName = intverfileEntry.getDynamicObject("user").getString("name");
            String number = interviewerEntry.getString("number");
            long applyId = interviewerEntry.getLong("applyid");
            Date expireTime = interviewerEntry.getDate("expiretime");
            String enable = interviewerEntry.getString("enable");
            if (expireTime.getTime() < now.getTime()) {
                errMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u5ef6\u671f\u5931\u8d25", (String)"InterviewerHelper_2", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
                if (tail) {
                    view.showErrorNotification(errMsg);
                } else {
                    showConfirmStr.append("\r\n").append(number).append(":").append(errMsg);
                }
                ++errNum;
                continue;
            }
            if (DateUtils.addMonths((Date)expireTime, (int)-1).getTime() > now.getTime()) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u8ddd\u79bb\u5230\u671f\u65e530\u5929\u5185\u518d\u64cd\u4f5c", (String)"InterviewerHelper_3", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
                if (tail) {
                    view.showTipNotification(errMsg);
                } else {
                    showConfirmStr.append("\r\n").append(number).append(':').append(errMsg);
                }
                ++errNum;
                continue;
            }
            if (InterviewerHelper.isChange(listPair, applyId)) {
                errMsg = ResManager.loadKDString((String)"\u9762\u8bd5\u5b98\u7c7b\u578b\u6216\u7b49\u7ea7\u5df2\u4fee\u6539\uff0c\u65e0\u6cd5\u5ef6\u671f", (String)"InterviewerHelper_6", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
                if (tail) {
                    view.showErrorNotification(errMsg);
                } else {
                    showConfirmStr.append("\r\n").append(number).append(':').append(errMsg);
                }
                ++errNum;
                continue;
            }
            if ("0".equals(enable)) {
                errMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u540e\u518d\u5ef6\u671f\u3002", (String)"InterviewerHelper_7", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
                if (tail) {
                    view.showTipNotification(errMsg);
                } else {
                    showConfirmStr.append("\r\n").append(number).append(':').append(errMsg);
                }
                ++errNum;
                continue;
            }
            if ("appdealy".equals(appdealy)) {
                if (tail) {
                    InterviewerHelper.isTail(view, interviewerEntry);
                }
            } else {
                InterviewerHelper.notAppdealy(view, interviewerEntry, tail, userId, expireTime, userName);
            }
            InterviewerDBHelper.delayEntry(interviewerEntry);
            showConfirmStr.append("\r\n").append(number).append(':').append(ResManager.loadKDString((String)"\u5ef6\u671f\u6210\u529f", (String)"InterviewerHelper_4", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
            ++sucNum;
        }
        if (!tail) {
            view.showConfirm(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c%2$s\u6761\u6210\u529f\uff0c%3$s\u6761\u5931\u8d25\u3002", (String)"InterviewerHelper_8", (String)"tsc-tsivm-formplugin", (Object[])new Object[0]), pkIds.length, sucNum, errNum), showConfirmStr.toString(), MessageBoxOptions.OK, ConfirmTypes.Save, null, null);
        }
    }

    private static void isTail(IFormView view, DynamicObject interviewerEntry) {
        if ("A".equals(interviewerEntry.get("applyextstatus"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u5df2\u64cd\u4f5c\u8fc7\u7533\u8bf7\u5ef6\u671f", (String)"InterviewerHelper_9", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u5ef6\u671f\u6210\u529f", (String)"InterviewerHelper_5", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
            interviewerEntry.set("applyextstatus", (Object)"A");
        }
    }

    private static void notAppdealy(IFormView view, DynamicObject interviewerEntry, boolean tail, long userId, Date expireTime, String userName) {
        interviewerEntry.set("expiretime", (Object)DateUtils.addYears((Date)expireTime, (int)1));
        if (tail) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5ef6\u671f\u6210\u529f", (String)"InterviewerHelper_4", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        }
        interviewerEntry.set("applyextstatus", (Object)"");
        ArrayList<Long> interviewids = new ArrayList<Long>(1);
        interviewids.add(userId);
        InterviewerHelper.sendMessage("\u60a8\u7684\u9762\u8bd5\u5b98\u8d44\u8d28\u5df2\u5ef6\u671f", "\u60a8\u7684\u9762\u8bd5\u5b98\u8d44\u8d28\u5df2\u5ef6\u671f\uff01", interviewids, UserServiceHelper.getCurrentUserId(), "\u5ef6\u671f\u901a\u77e5", userName);
    }

    private static boolean isChange(List<Pair<Long, List<String>>> listPair, long applyId) {
        boolean returnBoolean = false;
        if (listPair == null || listPair.isEmpty()) {
            return false;
        }
        for (Pair<Long, List<String>> pair : listPair) {
            List list;
            if (!((Long)pair.getKey()).equals(applyId) || (list = (List)pair.getValue()) == null || list.isEmpty()) continue;
            returnBoolean = true;
        }
        return returnBoolean;
    }

    public static boolean verifyHasPerm(String entityId) {
        String permCode = PERM_MAP.get(DELAYE);
        if (HRStringUtils.isEmpty((String)permCode)) {
            return true;
        }
        String appId = AppMetadataCache.getAppInfo((String)"tsivm").getId();
        int perm = PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (Long)RequestContext.get().getOrgId(), (String)appId, (String)entityId, (String)permCode);
        return perm == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapperFieldToExcel(File file, ListView listView, Map<String, List<Object>> dataCache) {
        block15: {
            XSSFWorkbook wb;
            FileOutputStream out;
            block14: {
                if (file == null) {
                    return;
                }
                out = null;
                FileInputStream fis = null;
                wb = null;
                int start = 0;
                int end = 500;
                try {
                    fis = new FileInputStream(file);
                    wb = new XSSFWorkbook((InputStream)fis);
                    Sheet sheet = wb.getSheetAt(0);
                    IListModel listModel = listView.getListModel();
                    BillList billList = InterviewerHelper.getBillList((IFormView)listView);
                    int selectRows = billList.getSelectedRows().size();
                    if (selectRows > 0) {
                        InterviewerHelper.setmodel(dataCache, sheet, listModel);
                    } else {
                        int rowCount;
                        do {
                            QueryResult rows = billList.queryBatchData(start, end);
                            DynamicObjectCollection exportDataList = rows.getCollection();
                            InterviewerHelper.writeDataListToFile(sheet, exportDataList, dataCache);
                            rowCount = exportDataList.size();
                            start += rowCount;
                        } while (rowCount != 0);
                    }
                    out = new FileOutputStream(file);
                    wb.write((OutputStream)out);
                    if (null == fis) break block14;
                }
                catch (IOException ex) {
                    LOGGER.error("generator recommend fail");
                    break block15;
                }
                finally {
                    if (null != fis) {
                        InterviewerHelper.safeClose(fis);
                    }
                    if (null != out) {
                        InterviewerHelper.safeClose(out);
                    }
                    if (null != wb) {
                        InterviewerHelper.safeClose((Closeable)wb);
                    }
                }
                InterviewerHelper.safeClose(fis);
            }
            if (null != out) {
                InterviewerHelper.safeClose(out);
            }
            if (null != wb) {
                InterviewerHelper.safeClose((Closeable)wb);
            }
        }
    }

    private static void setmodel(Map<String, List<Object>> dataCache, Sheet sheet, IListModel listModel) {
        QueryResult queryResult = listModel.getQueryResult();
        DynamicObjectCollection exportDataList = queryResult.getCollection();
        InterviewerHelper.writeDataListToFile(sheet, exportDataList, dataCache);
    }

    private static BillList getBillList(IFormView view) {
        return (BillList)view.getControl("billlistap");
    }

    private static void writeDataListToFile(Sheet sheet, DynamicObjectCollection exportDataList, Map<String, List<Object>> dataCache) {
        int j = exportDataList.size();
        for (int i = 0; i < j; ++i) {
            DynamicObject exportData = (DynamicObject)exportDataList.get(i);
            String id = exportData.getString("applynumber");
            List<Object> data = dataCache.get(id);
            Row row = sheet.getRow(i + 1);
            Cell cell = row.getCell(7);
            if (cell == null) {
                row.createCell(7, CellType.STRING).setCellValue(data.get(0).toString());
            } else {
                cell.setCellValue(data.get(0).toString());
            }
            cell = row.getCell(10);
            if (cell == null) {
                row.createCell(10, CellType.STRING).setCellValue(data.get(1).toString());
            } else {
                cell.setCellValue(data.get(1).toString());
            }
            cell = row.getCell(11);
            if (cell == null) {
                row.createCell(11, CellType.STRING).setCellValue(data.get(2).toString());
                continue;
            }
            cell.setCellValue(data.get(2).toString());
        }
    }

    public static void sendMessage(String title, String content, List<Long> interviewids, long senderId, String tag, String userName) {
        MessageInfo message = new MessageInfo();
        message.setType("notice");
        message.setNotifyType("sysnotice");
        message.setTitle(title);
        message.setUserIds(interviewids);
        if (senderId == 0L) {
            message.setSenderId(Long.valueOf(0L));
        } else {
            message.setSenderId(Long.valueOf(senderId));
        }
        message.setTag(title);
        message.setContent("\u3010" + userName + "\u3011" + content);
        message.setTag(tag);
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        message.setParams((Map)param);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static void setIntverEntry(DynamicObject entrys, Intverfileentry intverfileentry, Date pubTime) {
        Date effDate = DateUtils.parseDateTime((String)intverfileentry.getEfftime(), (String)"yyyy-MM-dd HH:mm:ss.sss");
        Date curDate = DateUtils.addMonths((Date)new Date(), (int)1);
        if (curDate.getTime() > pubTime.getTime() && pubTime.getTime() > System.currentTimeMillis()) {
            entrys.set("efftimered", (Object)DateUtils.formatDate((Date)pubTime, (Object[])new Object[0]));
        } else if (pubTime.getTime() < System.currentTimeMillis()) {
            entrys.set("efftimegrey", (Object)ResManager.loadKDString((String)"\u5df2\u8fc7\u671f", (String)"IntverFileentryPlugin_3", (String)"tsc-tsivm-formplugin", (Object[])new Object[0]));
        } else {
            entrys.set("efftimeblack", (Object)DateUtils.formatDate((Date)pubTime, (Object[])new Object[0]));
        }
        entrys.set("applyid", (Object)intverfileentry.getApplyid());
        entrys.set("applynumber", (Object)intverfileentry.getApplynumber());
        entrys.set("efftime", (Object)DateUtils.formatDate((Date)effDate, (Object[])new Object[0]));
        entrys.set("entryid", (Object)intverfileentry.getEntryid());
    }

    public static void setPicture(long userId, IFormView view) {
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds, (String[])new String[]{"picturefield"}, (String[])new String[]{"position"});
        String pictureId = (String)((Map)userInfoList.get(0)).get("picturefield");
        if (HRStringUtils.isEmpty((String)pictureId)) {
            view.setVisible(Boolean.FALSE, new String[]{"headsculpture"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"defimageap"});
        }
    }

    public static void safeClose(Closeable io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException e) {
                LOGGER.error("close io fail");
            }
        }
    }

    static {
        PERM_MAP.put(DELAYE, DELAYENTRY);
    }
}

