/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.interviewer.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class InterviewerFamilyScmHelper {
    public static final String JOBLEVEL_NUMBER = "joblevel_number";
    public static final String JOBLEVEL_SEQ = "joblevel_seq";

    public static QFilter getJobScmFilter(DynamicObject jobScm) {
        QFilter filter = new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C"));
        if (null != jobScm) {
            filter.and(new QFilter("id", "!=", (Object)jobScm.getLong("id")));
        }
        return filter;
    }

    public static QFilter getJobFamilyFilter(DynamicObject jobScm, DynamicObjectCollection jobFamily) {
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScm.getLong("id"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{scmFilter});
        List familyIds = Arrays.stream(dys).filter(dy -> Objects.nonNull(dy.getDynamicObject("jobfamily"))).map(dy -> dy.getDynamicObject("jobfamily").getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", familyIds);
        if (Objects.nonNull(jobFamily)) {
            for (DynamicObject family : jobFamily) {
                filter.and(new QFilter("id", "!=", (Object)family.getLong("jobfamilyhr.id")));
            }
        }
        return filter;
    }

    public static QFilter getJobClassFilter(DynamicObject jobScm, DynamicObjectCollection jobFamily, DynamicObjectCollection jobClass) {
        QFilter jobClassFilter = new QFilter("jobscm", "=", (Object)jobScm.getLong("id"));
        ArrayList<Long> jobFamilyIds = new ArrayList<Long>(10);
        for (DynamicObject family : jobFamily) {
            jobFamilyIds.add(family.getLong("jobfamilyhr.id"));
        }
        jobClassFilter.and(new QFilter("jobfamily", "in", jobFamilyIds));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{jobClassFilter});
        List jobClassIds = Arrays.stream(dys).filter(dy -> Objects.nonNull(dy.getDynamicObject("jobclass"))).map(dy -> dy.getDynamicObject("jobclass").getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", jobClassIds);
        if (null != jobClass) {
            for (DynamicObject jClass : jobClass) {
                filter.and(new QFilter("id", "!=", (Object)jClass.getLong("jobclasshr.id")));
            }
        }
        return filter;
    }

    public static Map<String, DynamicObject> getJobLevelRange(DynamicObject jobScm, DynamicObject jobClass) {
        DynamicObject jobLevelScm;
        Long jobScmId = jobScm.getLong("id");
        Long jobClassId = jobClass.getLong("id");
        DynamicObject jobClassDy = InterviewerFamilyScmHelper.getJobClassByJobClass(jobClassId, jobScmId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_joblevelhr");
        HashMap<String, DynamicObject> jobLevel = new HashMap<String, DynamicObject>(16);
        if (jobClassDy == null) {
            return jobLevel;
        }
        DynamicObject lowJobLevel = jobClassDy.getDynamicObject("lowjoblevel");
        DynamicObject highJobLevel = jobClassDy.getDynamicObject("highjoblevel");
        if (lowJobLevel == null || highJobLevel == null) {
            return jobLevel;
        }
        int lowjoblevelseq = lowJobLevel.getInt("joblevelseq");
        QFilter lowFilter = new QFilter("joblevelseq", "=", (Object)lowjoblevelseq);
        int highjoblevelseq = highJobLevel.getInt("joblevelseq");
        QFilter highFilter = new QFilter("joblevelseq", "=", (Object)highjoblevelseq);
        DynamicObject jobFamily = InterviewerFamilyScmHelper.getJobFamilyByJobClass(jobClassDy.getDynamicObject("jobclass"));
        DynamicObject jobFamilyDy = InterviewerFamilyScmHelper.getJobFamilyByJobFamily(jobFamily.getLong("id"), jobScmId);
        if (jobFamilyDy != null && Objects.nonNull(jobLevelScm = jobFamilyDy.getDynamicObject("joblevelscm"))) {
            lowFilter.and(new QFilter("joblevelscm", "=", (Object)jobLevelScm.getLong("id")));
            highFilter.and(new QFilter("joblevelscm", "=", (Object)jobLevelScm.getLong("id")));
        }
        jobLevel.put("lowjoblevel", serviceHelper.loadDynamicObject(lowFilter));
        jobLevel.put("highjoblevel", serviceHelper.loadDynamicObject(highFilter));
        return jobLevel;
    }

    public static DynamicObject getJobLevel(DynamicObject jobScm, DynamicObject jobFamily) {
        Long jobScmId = jobScm.getLong("id");
        Long jobFamilyId = jobFamily.getLong("id");
        DynamicObject jobFamilyDy = InterviewerFamilyScmHelper.getJobFamilyByJobFamily(jobFamilyId, jobScmId);
        if (jobFamilyDy == null) {
            return null;
        }
        return jobFamilyDy.getDynamicObject("joblevelscm");
    }

    public static Map<String, String> getJobLevelHR(DynamicObject jobLevelScm) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_joblevelscmhr");
        QFilter filter = new QFilter("id", "=", (Object)jobLevelScm.getLong("id"));
        DynamicObject jobLevelHR = serviceHelper.loadDynamicObject(filter);
        DynamicObjectCollection hrLevel = jobLevelHR.getDynamicObjectCollection("entryentity");
        HashMap<String, String> jobLevelRangeNum = new HashMap<String, String>(16);
        HashMap<String, Integer> jobLevelRangeSeq = new HashMap<String, Integer>(16);
        for (int num = 0; num < hrLevel.size(); ++num) {
            if (num == 0) {
                jobLevelRangeNum.put("lowjoblevel", ((DynamicObject)hrLevel.get(num)).getString(JOBLEVEL_NUMBER));
                jobLevelRangeSeq.put("lowjoblevel", ((DynamicObject)hrLevel.get(num)).getInt(JOBLEVEL_SEQ));
                jobLevelRangeNum.put("highjoblevel", ((DynamicObject)hrLevel.get(num)).getString(JOBLEVEL_NUMBER));
                jobLevelRangeSeq.put("highjoblevel", ((DynamicObject)hrLevel.get(num)).getInt(JOBLEVEL_SEQ));
                continue;
            }
            if (((DynamicObject)hrLevel.get(num)).getInt(JOBLEVEL_SEQ) < (Integer)jobLevelRangeSeq.get("lowjoblevel")) {
                jobLevelRangeNum.put("lowjoblevel", ((DynamicObject)hrLevel.get(num)).getString(JOBLEVEL_NUMBER));
                jobLevelRangeSeq.put("lowjoblevel", ((DynamicObject)hrLevel.get(num)).getInt(JOBLEVEL_SEQ));
            }
            if (((DynamicObject)hrLevel.get(num)).getInt(JOBLEVEL_SEQ) <= (Integer)jobLevelRangeSeq.get("highjoblevel")) continue;
            jobLevelRangeNum.put("highjoblevel", ((DynamicObject)hrLevel.get(num)).getString(JOBLEVEL_NUMBER));
            jobLevelRangeSeq.put("highjoblevel", ((DynamicObject)hrLevel.get(num)).getInt(JOBLEVEL_SEQ));
        }
        return jobLevelRangeNum;
    }

    public static Map<String, Long> getjobLevelRangeId(Map<String, String> jobLevelRangeNum) {
        HashMap<String, Long> jobLevelRangeId = new HashMap<String, Long>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_joblevelhr");
        if (!jobLevelRangeNum.isEmpty()) {
            String lowjoblevelNum = jobLevelRangeNum.get("lowjoblevel");
            QFilter lowFilter = new QFilter("number", "=", (Object)lowjoblevelNum);
            jobLevelRangeId.put("lowjoblevel", serviceHelper.loadDynamicObject(lowFilter).getLong("id"));
            String highjoblevelNum = jobLevelRangeNum.get("highjoblevel");
            QFilter highFilter = new QFilter("number", "=", (Object)highjoblevelNum);
            jobLevelRangeId.put("highjoblevel", serviceHelper.loadDynamicObject(highFilter).getLong("id"));
        }
        return jobLevelRangeId;
    }

    public static DynamicObject getJobFamilyByJobClass(DynamicObject JobClass) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
        QFilter filter = new QFilter("id", "=", (Object)JobClass.getLong("id"));
        return serviceHelper.loadDynamicObject(filter).getDynamicObject("jobfamily");
    }

    private static QFilter buildJobLevelFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass) {
        DynamicObject jobClassDy;
        DynamicObject joblevelscm;
        Long jobScmId = jobScm.getLong("id");
        Long jobFamilyId = jobFamily.getLong("id");
        Long jobClassId = jobClass.getLong("id");
        Boolean qFilterFlag = Boolean.TRUE;
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject jobFamilyDy = InterviewerFamilyScmHelper.getJobFamilyByJobFamily(jobFamilyId, jobScmId);
        if (jobFamilyDy != null && Objects.nonNull(joblevelscm = jobFamilyDy.getDynamicObject("joblevelscm"))) {
            qFilterFlag = Boolean.FALSE;
            filters.add(new QFilter("joblevelscm", "=", (Object)joblevelscm.getLong("id")));
        }
        if ((jobClassDy = InterviewerFamilyScmHelper.getJobClassByJobClass(jobClassId, jobScmId)) != null) {
            int seq;
            DynamicObject lowJobLevel = jobClassDy.getDynamicObject("lowjoblevel");
            DynamicObject highJobLevel = jobClassDy.getDynamicObject("highjoblevel");
            if (Objects.nonNull(lowJobLevel)) {
                qFilterFlag = Boolean.FALSE;
                seq = lowJobLevel.getInt("joblevelseq");
                QFilter lowFilter = new QFilter("joblevelseq", ">=", (Object)seq);
                filters.add(lowFilter);
            }
            if (Objects.nonNull(highJobLevel)) {
                qFilterFlag = Boolean.FALSE;
                seq = highJobLevel.getInt("joblevelseq");
                QFilter highFilter = new QFilter("joblevelseq", "<=", (Object)seq);
                filters.add(highFilter);
            }
        }
        if (qFilterFlag.booleanValue()) {
            QFilter nullFilter = new QFilter("joblevelseq", ">", (Object)0);
            nullFilter.and(new QFilter("joblevelseq", "<", (Object)0));
            filters.add(nullFilter);
        }
        HRBaseServiceHelper jobLevelHelper = new HRBaseServiceHelper("hbjm_joblevelhr");
        DynamicObject[] jobLevelDys = jobLevelHelper.loadDynamicObjectArray(filters.toArray(new QFilter[0]));
        List ids = Arrays.stream(jobLevelDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return new QFilter("id", "in", ids);
    }

    public static QFilter getLowJobLevelFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass, DynamicObject highJobLevel) {
        QFilter filter = InterviewerFamilyScmHelper.buildJobLevelFilter(jobScm, jobFamily, jobClass);
        if (null != highJobLevel) {
            int jobLevelSeq = highJobLevel.getInt("joblevelseq");
            filter.and(new QFilter("joblevelseq", "<=", (Object)jobLevelSeq));
        }
        return filter;
    }

    public static QFilter getHighJobLevelFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass, DynamicObject lowJobLevel) {
        QFilter filter = InterviewerFamilyScmHelper.buildJobLevelFilter(jobScm, jobFamily, jobClass);
        if (null != lowJobLevel) {
            int jobLevelSeq = lowJobLevel.getInt("joblevelseq");
            filter.and(new QFilter("joblevelseq", ">=", (Object)jobLevelSeq));
        }
        return filter;
    }

    public static DynamicObject getJobFamilyByJobFamily(Long jobFamily, Long jobScm) {
        QFilter jobFamilyFilter = new QFilter("jobfamily.id", "=", (Object)jobFamily);
        jobFamilyFilter.and("jobscm", "=", (Object)jobScm);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        return serviceHelper.loadDynamicObject(jobFamilyFilter);
    }

    public static DynamicObject getJobClassByJobClass(Long jobClass, Long jobScm) {
        QFilter jobClassFilter = new QFilter("jobclass.id", "=", (Object)jobClass);
        jobClassFilter.and("jobscm", "=", (Object)jobScm);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        return serviceHelper.loadDynamicObject(jobClassFilter);
    }
}

