/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.interviewer.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.AppMetadataCache;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class InterviewerPermHelper {
    public static final String MODIFY_PERM = "4715a0df000000ac";
    public static final String DELETE_PERM = "4715e1f1000000ac";
    private static final Map<String, String> PERM_MAP = new HashMap<String, String>(16);

    public static InterviewerPermHelper getInstance() {
        return InterviewerPermHelperHolder.INTERVIEWER_PERM_HELPER;
    }

    public boolean verifyHasPerm(String entityId, String operateCode, long useOrgId) {
        String permCode = PERM_MAP.get(operateCode);
        String appId = AppMetadataCache.getAppInfo((String)"tssrm").getId();
        if (HRStringUtils.isEmpty((String)permCode)) {
            return true;
        }
        int perm = PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (Long)useOrgId, (String)appId, (String)entityId, (String)permCode);
        return perm == 1;
    }

    public boolean verifyHasIntvTypePerm(String operateCode) {
        return this.verifyHasPerm("tsrbd_intvertype", operateCode, TSCRequestContext.getOrgId());
    }

    public boolean verifyHasIntvLevelPerm(String operateCode) {
        return this.verifyHasPerm("tsrbd_intverlevel", operateCode, TSCRequestContext.getOrgId());
    }

    static {
        PERM_MAP.put("modify", MODIFY_PERM);
        PERM_MAP.put("delete", DELETE_PERM);
    }

    private static class InterviewerPermHelperHolder {
        private static final InterviewerPermHelper INTERVIEWER_PERM_HELPER = new InterviewerPermHelper();

        private InterviewerPermHelperHolder() {
        }
    }
}

