/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.interviewer.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class InterviewerQueryHelper {
    public static final HRBaseServiceHelper typeServiceHelper = new HRBaseServiceHelper("tsrbd_intvertype");
    public static final HRBaseServiceHelper levelServiceHelper = new HRBaseServiceHelper("tsrbd_intverlevel");

    public static List<Map<String, DynamicObject>> getIntvRange(Long intvLevelId) {
        QFilter filter = new QFilter("id", "=", (Object)intvLevelId);
        DynamicObject intvLevel = levelServiceHelper.loadDynamicObject(filter);
        DynamicObjectCollection rankRangeEntry = intvLevel.getDynamicObjectCollection("rankrangeentry");
        ArrayList<Map<String, DynamicObject>> jobClassList = new ArrayList<Map<String, DynamicObject>>(10);
        for (DynamicObject rankRange : rankRangeEntry) {
            HashMap<String, DynamicObject> jobClassMap = new HashMap<String, DynamicObject>(16);
            DynamicObject jobClassHr = rankRange.getDynamicObject("jobclasshr");
            jobClassMap.put("jobclasshr", jobClassHr);
            jobClassMap.put("jobfamilyhr", jobClassHr.getDynamicObject("jobfamily"));
            jobClassMap.put("lowjoblevel", rankRange.getDynamicObject("lowjoblevel"));
            jobClassMap.put("highjoblevel", rankRange.getDynamicObject("highjoblevel"));
            jobClassList.add(jobClassMap);
        }
        return jobClassList;
    }

    public static DynamicObject getInterviewerTypeById(Long interviewerTypeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)interviewerTypeId);
        return typeServiceHelper.loadDynamicObject(qFilter);
    }

    public static DynamicObject[] getAllIntvLevelByIntvTypeId(Long interviewerTypeId) {
        QFilter interviewertypeFilter = new QFilter("interviewertype.id", "=", (Object)interviewerTypeId);
        return levelServiceHelper.loadDynamicObjectArray(interviewertypeFilter.toArray());
    }

    public static DynamicObject[] getAllEnableLevelByTypeId(Long interviewerTypeId) {
        QFilter interviewertypeFilter = new QFilter("interviewertype.id", "=", (Object)interviewerTypeId);
        interviewertypeFilter.and(new QFilter("enable", "=", (Object)"1"));
        return levelServiceHelper.loadDynamicObjectArray(interviewertypeFilter.toArray());
    }

    public static DynamicObject[] getAllIntvType() {
        return typeServiceHelper.loadDynamicObjectArray(new QFilter("enable", "=", (Object)"1").toArray());
    }

    public static DynamicObject getIntvLevelByTypeAndLevel(DynamicObject intvType, String level) {
        QFilter filter = new QFilter("interviewertype.id", "=", (Object)intvType.getLong("id"));
        filter.and(new QFilter("intverlevel", "=", (Object)level));
        return levelServiceHelper.loadDynamicObject(filter);
    }

    public static DynamicObject getIntvLevelById(Long intvLevelId) {
        QFilter filter = new QFilter("id", "=", (Object)intvLevelId);
        return levelServiceHelper.loadDynamicObject(filter);
    }

    public static DynamicObject getIntvLevelByNum(String intvLevelNum) {
        QFilter filter = new QFilter("number", "=", (Object)intvLevelNum);
        return levelServiceHelper.loadDynamicObject(filter);
    }
}

